<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:tei="http://www.tei-c.org/ns/1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    exclude-result-prefixes="#all"
    version="2.0">
    
    <!-- version: 5.2 /2017/ (c) Herzog August Bibliothek / schassan@hab.de -->
    
    <!-- falls das Skript lokal genutzt werden soll, bitte folgende Adresse eintragen: http://diglib.hab.de/rules/styles/mss/TEI-P5-to-Print/current/tei.xsl -->
    <xsl:import href="tei.xsl"/>
    <xsl:param name="pathToDescriptions"><!-- e.g. file:///D:/_handschriften/mss/ --></xsl:param>

    <xsl:output method="xhtml" encoding="UTF-8" indent="yes"/>
    <xsl:strip-space elements="*"/>

    <!--
    <xsl:template name="writeCitedMss">
        <xsl:for-each-group select="root()/descendant::tei:ref[(@type='mss') or (@type='altMs')] 
            | root()/descendant::tei:index[tei:term[.='Handschriften, erwähnte']]/tei:index/tei:term" 
            group-by="if (contains(@cRef, '_tei-msDesc')) then substring-before(@cRef, '_tei-msDesc') else if (@cRef) then @cRef else normalize-space(.)">
            <xsl:variable name="description" select="if (doc-available(concat($pathToDescriptions[.!=''], current-grouping-key(), '/tei-msDesc.xml'))) 
                then doc(concat($pathToDescriptions[.!=''], current-grouping-key(), '/tei-msDesc.xml')) 
                else ''"/>
            <xsl:choose>
                <xsl:when test="$description != ''">
                    <index>
                        <term>
                            <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:settlement"/>
                            <xsl:text>, </xsl:text>
                            <xsl:choose>
                                <xsl:when test="($description//tei:msDesc/tei:msIdentifier/tei:repository = 'Herzog August Bibliothek')">
                                    <xsl:text>HAB Cod. Guelf.</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:repository"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="$description//tei:msDesc/tei:msIdentifier/tei:idno/@sortKey"/>
                                <xsl:choose>
                                    <xsl:when test="$description//tei:msDesc/tei:msIdentifier/tei:repository = 'Herzog August Bibliothek'">
                                        <xsl:value-of select="substring-after($description//tei:msDesc/tei:msIdentifier/tei:idno, 'Cod. Guelf. ')"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:idno"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </term>
                            <xsl:for-each select="current-group()">
                                <xsl:call-template name="writeIdno"/>
                            </xsl:for-each>
                        </index>
                    </index>
                </xsl:when>
                <xsl:when test="starts-with(current-grouping-key(), 'ba-')">
                    <index>
                        <term>Wolfenbüttel, HAB Bibliotheksarchiv</term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="concat('wf_hab_', current-grouping-key())"/>
                                <xsl:value-of select="translate(substring-after(current-grouping-key(), 'ba-'), 'eiv-', 'EIV ')"/>
                            </term>
                            <xsl:for-each select="current-group()">
                                <xsl:call-template name="writeIdno"/>
                            </xsl:for-each>
                        </index>
                    </index>
                    
                </xsl:when>
                <xsl:when test="count(tokenize(current-grouping-key(), ',')) >= 3">
                    <index>
                        <term><xsl:value-of select="concat(tokenize(current-grouping-key(), ',')[1], ', ', tokenize(current-grouping-key(), ',')[2])"/></term>
                        <index>
                            <term><xsl:value-of select="substring-after(substring-after(current-grouping-key(), ','), ',')"/></term>
                            <xsl:for-each select="current-group()">
                                <xsl:call-template name="writeIdno"/>
                            </xsl:for-each>
                        </index>
                    </index>
                </xsl:when>
                <xsl:otherwise>
                    <index>
                        <term><xsl:value-of select="current-grouping-key()"/></term>
                        <xsl:for-each select="current-group()">
                            <xsl:call-template name="writeIdno"/>
                        </xsl:for-each>
                    </index>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each-group>
    </xsl:template>
    -->

</xsl:stylesheet>