<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:tei="http://www.tei-c.org/ns/1.0" version="2.0">
	<!-- URN-Bestandteile -->
	<xsl:param name="urn-resolver">http://nbn-resolving.de/urn/resolver.pl?urn=</xsl:param>
	<xsl:param name="urn-base">urn:nbn:</xsl:param>
	<xsl:param name="urn-country">de</xsl:param>
	<xsl:param name="urn-network">gbv</xsl:param>
	<xsl:param name="urn-library">23</xsl:param>
	<xsl:param name="collection">mss</xsl:param>
	<!-- Ende URN-Bestandteile -->
	<xsl:param name="settlement">Wolfenbüttel</xsl:param>
	<xsl:param name="repository_short">HAB</xsl:param>
	<!-- Webserver für Digitalisierungen -->
	<xsl:param name="server">http://diglib.hab.de/</xsl:param>
	<xsl:param name="server-path">mss/</xsl:param>
	<xsl:param name="xmlid">
		<xsl:value-of
			select="replace(replace(replace(replace(replace(replace(replace(translate(translate(lower-case(//tei:msDesc/tei:msIdentifier/tei:idno),'.',''),' ','-'),'fol','2f'),'4to','4f'),'8vo','8f'),'12mo','12f'),'α','alpha'),'β','beta'),'—','--')"
		 />
	</xsl:param>
	<xsl:param name="abfrage">/start.htm?image=</xsl:param>
	<!-- Ende Webserver für Digitalisierungen -->
	<!-- Verknüpfung zur Literatur (OPAC, Literaturdatenbank, etc.) -->
	<xsl:param name="Verbund">hab</xsl:param>
	<xsl:param name="Suchfeld">ppn</xsl:param>
	<xsl:param name="OPAC">http://opac.lbs-braunschweig.gbv.de/DB=2/CMD?ACT=SRCHA&amp;TRM=PPN+</xsl:param>
	<!-- GBV: http://gso.gbv.de/DB=2.1/CMD?ACT=SRCHA&TRM=ppn+ -->
	<!--d-nb: http://dispatch.opac.ddb.de/DB=4.1/PPN?PPN=-->
	<!-- $literaturDB - mögliche Werte: eine URL der Datenbank oder leer lassen -->
	<xsl:param name="literaturDB" />
	<!--http://194.95.134.232/mssdoku/find.php?urG=CLA%20&urS=-->
	<xsl:param name="regex">(\d*)(\D)?-(\D*)-?(\d°)?</xsl:param>
	<!-- Ende Verknüpfung zur Literatur -->
	<!-- Nachweis des Copyright -->
	<xsl:param name="availability">restricted</xsl:param>
	<xsl:param name="availabilityDesc">http://diglib.hab.de/?link=012</xsl:param>
	<!-- mögliche Verknüpfungen mit Ressourcen für kanonische Zitate: Bibel, MGH, etc. -->
	<xsl:param name="cRef-biblical-start">http://www.biblija.net/biblija.cgi?m=</xsl:param>
	<xsl:param name="cRef-biblical-end">&amp;id8=1&amp;id12=1&amp;set=1&amp;l=en</xsl:param>
	<!-- auch: http://www.bibelgesellschaft.de/channel.php?channel=35&INPUT=; ohne cRef-end -->
	<!-- Ende mögliche Verknüpfungen mit Ressourcen für kanonische Zitate -->
	<xsl:param name="css-file">../styles/druck.css</xsl:param>
	<xsl:param name="Trennzeichen"> — </xsl:param>
	<xsl:param name="Status">fertig</xsl:param>
	<!-- mögliche Werte: vorlaeufig/fertig -->
	<!-- für alle folgenden Parameter mögliche Werte: yes/no -->
	<xsl:param name="alleElementeAnzeigen">yes</xsl:param>
	<xsl:param name="EinzeldateienAusgeben">yes</xsl:param>
	<xsl:param name="mehrereKatalogisatePublizieren">no</xsl:param>
	<xsl:param name="msPartUeberschriftAnzeigen">no</xsl:param>
	<xsl:param name="registerAnzeigen">yes</xsl:param>
	<xsl:param name="abgekuerzteLiteraturAuflisten">yes</xsl:param>
	<xsl:param name="Autorname">no</xsl:param>
</xsl:stylesheet>
