<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:tei="http://www.tei-c.org/ns/1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="#all"
    version="2.0">
    
    <!-- version: 5.3 /2019-/ (c) Herzog August Bibliothek / schassan@hab.de -->
    
    <!-- to do
		tei:label berücksichtigen?! 
	-->
    
    <!-- falls das Skript lokal genutzt werden soll, bitte folgende Adresse eintragen: https://diglib.hab.de/rules/styles/mss/TEI-P5-to-Print/current/param.xsl -->
    <xsl:import href="paramForIndices.xsl"/>
    <xsl:variable name="stopwordList" select="doc($pathToStopwordList)"/>

    <xsl:template name="writeIndexCitedMs">
        <xsl:variable name="temporalIndex">
            <list><xsl:call-template name="writeCitedMss"/></list>
        </xsl:variable>
        <ul>
            <xsl:call-template name="writeFinalIndex">
                <xsl:with-param name="temporalIndex" select="$temporalIndex"/>
                <xsl:with-param name="indexName" select=" 'mss' "/>
            </xsl:call-template>
        </ul>
    </xsl:template>
    <xsl:template name="writeIndexGeneral">
        <p>Nachgestellte Siglen bezeichnen Vorbesitzer (P), Schriftheimat oder Entstehungsort (Pr), Schreiber (S) und Übersetzer (Ü). 
            <xsl:choose>
                <xsl:when test="($ignoreInIdno != '') and ($ignoreInIdnoPraefix != '') and ($ignoreInIdno != $ignoreInIdnoPraefix)">
                    <xsl:text>Alle Signaturen sind um die Bestandteile &apos;</xsl:text>
                    <xsl:value-of select="$ignoreInIdnoPraefix"/>
                    <xsl:text>&apos; und &apos;</xsl:text> 
                    <xsl:value-of select="$ignoreInIdno"/>
                    <xsl:text>&apos; gekürzt: &apos;</xsl:text>
                    <xsl:value-of select="root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc[1]/tei:msIdentifier/tei:idno"/>
                    <xsl:text>&apos; wird angezeigt als &apos;</xsl:text>
                    <xsl:value-of select="normalize-space(replace(substring-after(root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc[1]/tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix), $ignoreInIdno, ''))"/>
                    <xsl:text>&apos;</xsl:text>
                </xsl:when>
                <xsl:when test="($ignoreInIdnoPraefix != '')">
                    <xsl:text>Alle Signaturen sind um den Bestandteil &apos;</xsl:text>
                    <xsl:value-of select="$ignoreInIdnoPraefix"/>
                    <xsl:text>&apos; gekürzt: &apos;</xsl:text>
                    <xsl:value-of select="root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc[1]/tei:msIdentifier/tei:idno"/>
                    <xsl:text>&apos; wird angezeigt als &apos;</xsl:text>
                    <xsl:value-of select="normalize-space(substring-after(root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc[1]/tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix))"/>
                    <xsl:text>&apos;</xsl:text>
                </xsl:when>
                <xsl:when test="($ignoreInIdno != '')">
                    <xsl:text>Alle Signaturen sind um den Bestandteil &apos;</xsl:text>
                    <xsl:value-of select="$ignoreInIdno"/>
                    <xsl:text>&apos; gekürzt: &apos;</xsl:text>
                    <xsl:value-of select="root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc[1]/tei:msIdentifier/tei:idno"/>
                    <xsl:text>&apos; wird angezeigt als &apos;</xsl:text>
                    <xsl:value-of select="normalize-space(replace(root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc[1]/tei:msIdentifier/tei:idno, $ignoreInIdno, ''))"/>
                    <xsl:text>&apos;</xsl:text>
                </xsl:when>
            </xsl:choose>
        </p>
        <xsl:variable name="temporalIndex">
            <xsl:variable name="toBeReplaced"> /()?,;.:&lt;&gt;&apos;[]*</xsl:variable>
            <xsl:variable name="replacedBy">_-</xsl:variable>
            <list>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:author[parent::tei:msItem][not(. = '')]"/>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:msContents/tei:msItem/tei:title[not(preceding-sibling::tei:author[not(. = '')]) and not(preceding-sibling::tei:rs[@role = 'author'][not(. = '')])][not(@type = 'sub')]"/>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:accMat/tei:title[not(preceding-sibling::tei:author[not(. = '')]) and not(preceding-sibling::tei:rs[@role = 'author'][not(. = '')])][not(@type = 'sub')]"/>
                <xsl:choose>
                    <xsl:when test="($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum')">
                        <xsl:apply-templates mode="Register" select="root()/descendant::tei:index[not(parent::tei:index)][ancestor::tei:msDesc]
                            [
                            not(@indexName = 'initien') and 
                            not(@indexName = 'bmicon') and 
                            not(tei:term[. = 'Handschriften, erwähnte'])
                            ]"/><!-- not(tei:term[.='Palimpsest']) and -->
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates mode="Register" select="root()/descendant::tei:index[not(parent::tei:index)][ancestor::tei:msDesc]
                            [not(@indexName='initien') and not(tei:term[.='Handschriften, erwähnte'])]"/><!-- not(tei:term[.='Palimpsest']) and -->
                    </xsl:otherwise>
                </xsl:choose>
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select=" 'datierung-der-handschriften' "/>
                        <xsl:text>Datierung der Handschriften</xsl:text>
                    </term>
                    <xsl:if test="root()/descendant::tei:origDate[parent::tei:head/parent::tei:msDesc or parent::tei:head/parent::tei:msPart or ancestor::tei:origin][@when[.!=''] or (@notBefore = @notAfter)]">
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select=" 'datierte-handschriften' "/>
                                <xsl:text>Datierte Handschriften</xsl:text>
                            </term>
                            <xsl:apply-templates mode="Register" select="root()/descendant::tei:origDate[parent::tei:head/parent::tei:msDesc or parent::tei:head/parent::tei:msPart or ancestor::tei:origin][@when[.!=''] or (@notBefore = @notAfter)]"/>
                        </index>
                    </xsl:if>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select=" 'zeiträume' "/>
                            <xsl:text>Zeiträume</xsl:text>
                        </term>
                        <xsl:apply-templates mode="Register" select="root()/descendant::tei:origDate[parent::tei:head or ancestor::tei:origin][@notBefore != @notAfter]"/>
                    </index>
                </index>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:title[contains(., 'Palimpsest')][ancestor::tei:msDesc]"/>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:msPart[(@rend = 'condensed') or (contains(tei:msIdentifier/tei:idno, 'Fragment') and not(descendant::tei:term[contains(., 'Fragment')]))]"/>
                <!-- notwendig ???
                <xsl:apply-templates mode="Register" select="descendant::tei:accMat[not(descendant::tei:term[contains(., 'Fragment')])][contains(., 'Fragment')]"/>
-->
                <xsl:if test="root()/descendant::tei:colophon and not(descendant::tei:term[.='Kolophon'])">
                    <xsl:apply-templates mode="Register" select="root()/tei:colophon"/>
                </xsl:if>
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select=" 'provenienz_1' "/>
                        <xsl:text>Provenienz I (Schriftheimat, Entstehungsort)</xsl:text>
                    </term>
                    <xsl:apply-templates mode="Register" select="root()/descendant::tei:origPlace"/>
                </index>
                <xsl:if test="root()/descendant::tei:rs[@role = 'owner_previous']">
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select=" 'provenienz_2' "/>
                            <xsl:text>Provenienz II (Vorbesitzer) siehe </xsl:text>
                            <xsl:for-each-group select="root()/descendant::tei:rs[@role = 'owner_previous'][ancestor::tei:msDesc]" group-by="if (@ref) then @ref else normalize-space(.)">
                                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="lower-case(translate(current-grouping-key(), $toBeReplaced, $replacedBy))"/>
                                <xsl:call-template name="writeEntity">
                                    <xsl:with-param name="value">
                                        <xsl:choose>
                                            <xsl:when test="starts-with(current-grouping-key(), '#')"><xsl:value-of select="substring(current-grouping-key(), 2)"/></xsl:when>
                                            <xsl:otherwise><xsl:value-of select="current-grouping-key()"/></xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:if test="not(position() = last()) and not(ends-with(current-grouping-key(), '.'))">
                                    <xsl:text>. </xsl:text>
                                </xsl:if>
                            </xsl:for-each-group>
                        </term>
                    </index>
                </xsl:if>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:origPlace">
                    <xsl:with-param name="addInfo" select=" ' (Pr) ' "/>
                </xsl:apply-templates>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:rs[not(@role = 'author') and not(@ref = ancestor::tei:msDesc/descendant::tei:author/@ref)]"/>
                <xsl:if test="root()/descendant::tei:handNote[@scribe or @scribeRef]">
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select=" 'schreiber_siehe' "/>
                            <xsl:text>Schreiber siehe </xsl:text> 
                            <xsl:for-each-group select="root()/descendant::tei:handNote[@scribeRef]" group-by="@scribeRef">
                                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="lower-case(translate(current-grouping-key(), $toBeReplaced, $replacedBy))"/>
                                <xsl:call-template name="writeEntity">
                                    <xsl:with-param name="value">
                                        <xsl:choose>
                                            <xsl:when test="starts-with(current-grouping-key(), '#')"><xsl:value-of select="substring(current-grouping-key(), 2)"/></xsl:when>
                                            <xsl:otherwise><xsl:value-of select="current-grouping-key()"/></xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:with-param>
                                </xsl:call-template>
                                <xsl:if test="not(position() = last()) and not(ends-with(current-grouping-key(), '.'))">
                                    <xsl:text>. </xsl:text>
                                </xsl:if>
                            </xsl:for-each-group>
                        </term>
                    </index>
                </xsl:if>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:handNote[@scribeRef]">
                    <!-- evtl.
                        tei:handNote[@scribe and not(@scribeRef)]
                    -->
                    <xsl:with-param name="addInfo" select=" ' (S) ' "/>
                    <xsl:with-param name="cert" select="if (@cert) then '(?)' else ''"/>
                </xsl:apply-templates>
                <xsl:if test="root()/descendant::tei:ref[(@type = 'mss') or (@type = 'altMs')] 
                    or root()/descendant::tei:msIdentifier[parent::tei:bibl]">
                    <xsl:choose>
                        <xsl:when test="$listMssSeperately = 'yes' ">
                            <index>
                                <term>
                                    <xsl:attribute name="sortKey" select=" 'handschriften-erwähnte-siehe' "/>
                                    <xsl:text>Handschriften, erwähnte siehe separates Register</xsl:text>
                                </term>
                            </index>
                        </xsl:when>
                        <xsl:otherwise>
                            <index>
                                <term>
                                    <xsl:attribute name="sortKey" select=" 'handschriften-erwähnte' "/>
                                    <xsl:text>Handschriften, erwähnte</xsl:text>
                                </term>
                                <xsl:call-template name="writeCitedMss"/>
                            </index>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </list>
        </xsl:variable>
        <ul>
            <xsl:call-template name="writeFinalIndex">
                <xsl:with-param name="temporalIndex" select="$temporalIndex"/>
                <xsl:with-param name="indexName" select=" 'NamenSachen' "/>
            </xsl:call-template>
        </ul>
    </xsl:template>
    <xsl:template name="writeIndexIllum">
        <xsl:variable name="temporalIndex">
            <list>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:index[@indexName='bmicon'][tei:term = 'Buchschmuck und Ikonographie']/tei:index"/>
                <!-- evtl. 
                        tei:incipit[not(normalize-space(.) = '')][not(@type='notInRegister')][not(parent::tei:msItem/tei:index[@indexName = 'initien'])] 
                    -->
            </list>
        </xsl:variable>
        <ul>
            <xsl:call-template name="writeFinalIndex">
                <xsl:with-param name="temporalIndex" select="$temporalIndex"/>
                <xsl:with-param name="indexName" select=" 'bmicon'"/>
            </xsl:call-template>
        </ul>
    </xsl:template>
    <xsl:template match="tei:divGen[@type = 'index'][@subtype = 'initien']">
        <xsl:variable name="temporalIndex">
            <list>
                <xsl:apply-templates mode="Register" select="root()/descendant::tei:index[not(parent::tei:index)][@indexName='initien']"/>
                <!-- evtl. 
                        tei:incipit[not(normalize-space(.) = '')][not(@type='notInRegister')][not(parent::tei:msItem/tei:index[@indexName = 'initien'])] 
                    -->
            </list>
        </xsl:variable>
        <ul>
            <xsl:call-template name="writeFinalIndex">
                <xsl:with-param name="temporalIndex" select="$temporalIndex"/>
                <xsl:with-param name="indexName" select=" 'initien'"/>
            </xsl:call-template>
        </ul>
    </xsl:template>
    <xsl:template name="generateIndices">
        <!-- ========== Initienregister ========== -->
        <xsl:if test="//tei:index[@indexName = 'initien']
            or //tei:incipit[not(normalize-space(.) = '')][not(@type = 'notInRegister')][not(parent::tei:msItem/tei:index[@indexName = 'initien'])]
            or //tei:quote[(@type='incipit') or tei:lg][not(normalize-space(.)='')][not(@type='notInRegister')]">
            <hr/>
            <p>
                <xsl:attribute name="class">head</xsl:attribute>
                <xsl:text>Initien</xsl:text>
            </p>
            <xsl:variable name="temporalIndex">
                <list>
                    <xsl:apply-templates mode="Register" select="descendant::tei:index[not(parent::tei:index)][@indexName='initien']"/>
                    <!-- evtl. 
                        tei:incipit[not(normalize-space(.) = '')][not(@type='notInRegister')][not(parent::tei:msItem/tei:index[@indexName = 'initien'])] 
                    -->
                </list>
            </xsl:variable>
            <ul>
                <xsl:call-template name="writeFinalIndex">
                    <xsl:with-param name="temporalIndex" select="$temporalIndex"/>
                    <xsl:with-param name="indexName" select=" 'initien'"/>
                </xsl:call-template>
            </ul>
        </xsl:if>
        <!-- ========== Register zu den Versus und Bibelprologen ========== -->
        <xsl:if test="not(($catalogueType = 'illum') or (ancestor-or-self::tei:msDesc/@type = 'illum')) and 
            descendant::tei:bibl[
               (tei:abbr = 'AH') 
            or (tei:abbr = 'BHL') 
            or (tei:abbr = 'BHL Novum Suppl.') 
            or (tei:abbr = 'Chevalier') 
            or (tei:abbr = 'Mone') 
            or (tei:abbr = 'Schaller/Könsgen')
            or (tei:abbr = 'Stegmüller RB')
            or (tei:abbr = 'Walther I')
            or (tei:abbr = 'Walther II')
            ]">
            <hr/>
            <p>
                <xsl:attribute name="class">head</xsl:attribute>
                <xsl:text>Register zu den Versus und Bibelprologen</xsl:text>
            </p>
            <xsl:variable name="temporalIndex">
                <list>
                    <xsl:apply-templates mode="Register" select="descendant::tei:bibl[
                           (tei:abbr = 'AH') 
                        or (tei:abbr = 'BHL')
                        or (tei:abbr = 'BHL Novum Suppl.')
                        or (tei:abbr = 'Chevalier') 
                        or (tei:abbr = 'Mone') 
                        or (tei:abbr = 'Schaller/Könsgen')
                        or (tei:abbr = 'Stegmüller RB')
                        or (tei:abbr = 'Walther I')
                        or (tei:abbr = 'Walther II')
                        ]"/>
                </list>
            </xsl:variable>
            <ul>
                <xsl:call-template name="writeFinalIndex">
                    <xsl:with-param name="temporalIndex" select="$temporalIndex"/>
                    <xsl:with-param name="indexName" select=" 'repertorien' "/>
                </xsl:call-template>
            </ul>
        </xsl:if>
        <!-- ========== Personen-, Orts- und Sachregister ========== -->
        <hr/>
        <p>
            <xsl:attribute name="class">head</xsl:attribute>
            <xsl:text>Personen-, Orts- und Sachregister</xsl:text>
        </p>
        <xsl:call-template name="writeIndexGeneral"/>
        <!-- ========== Buchschmuck ========== -->
        <xsl:if test="(($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum'))
            and //tei:index[@indexName = 'bmicon']">
            <hr/>
            <p>
                <xsl:attribute name="class">head</xsl:attribute>
                <xsl:text>Buchschmuck und Ikonographie</xsl:text>
            </p>
            <xsl:call-template name="writeIndexIllum"/>
        </xsl:if>
        <!-- ========== erwähnte Handschriften ========== -->
        <xsl:if test="$listMssSeperately = 'yes' and root()/descendant::tei:ref[(@type = 'mss') or (@type = 'altMs') or (@type = 'object')]">
            <hr/>
            <p>
                <xsl:attribute name="class">head</xsl:attribute>
                <xsl:choose>
                    <xsl:when test="(($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum'))">
                        <xsl:text>Handschriften und Kulturdenkmäler, erwähnte</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>Handschriften, erwähnte</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </p>
            <xsl:call-template name="writeIndexCitedMs"/>
        </xsl:if>
    </xsl:template>

    <!-- ========== element processing templates ========== -->
    <!-- ================================================== -->
    
    <xsl:template match="tei:author[parent::tei:msItem][not(. = '')]" mode="Register">
        <xsl:variable name="person" select="doc($listPerson)//tei:person[@xml:id[.=substring(current()/@ref,2)]]"/>
        <index>
            <term>
                <xsl:choose>
                    <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $person[. != '']">
                        <xsl:if test="$person/@sortKey">
                            <xsl:attribute name="sortKey" select="translate($person/@sortKey, ' /()?,;.:&lt;&gt;', '_-')"/>
                        </xsl:if>
                        <xsl:apply-templates select="$person" mode="Register"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="sortKey" select="translate(., ' /()?,;.:&lt;&gt;', '_-')"/>
                        <xsl:value-of select="."/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
            </term>
            <xsl:choose>
                <xsl:when test="following-sibling::tei:title[1][not(@type='sub')]">
                    <xsl:apply-templates select="following-sibling::tei:title[1][not(@type='sub')]" mode="Register"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="writeIdno"/>
                </xsl:otherwise>
            </xsl:choose>
        </index>
    </xsl:template>

    <xsl:template match="tei:bibl" mode="Register">
        <xsl:variable name="toBeReplaced" select=" ';.' "/>
        <xsl:variable name="replacedBy"/>
        <index>
            <term>
                <xsl:choose>
                    <xsl:when test="tei:abbr = 'AH'">Analecta Hymnica (Band, Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'BHL'">Bibliotheca hagiographica Latina antiquae et mediae aetatis (Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'BHL Novum Suppl.'">Bibliotheca hagiographica Latina antiquae et mediae aetatis (Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'Chevalier'"><span class="author">Chevalier</span>, Repertorium hymnologicum (Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'Mone'"><span class="author">Mone</span>, Lateinische Hymnen des Mittelalters, Bd. 1–3 (Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'Schaller/Könsgen'"><span class="author">Schaller/Könsgen</span> (Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'Stegmüller RB'">
                        <xsl:attribute name="sortKey" select=" 'zz_Stegmueller' "/>
                        <xsl:text>Bibelprologe und Bibelkommentare nach </xsl:text><span class="author">Stegmüller</span><xsl:text> RB (Nummer)</xsl:text>
                    </xsl:when>
                    <xsl:when test="tei:abbr = 'Walther I'"><span class="author">Walther</span> I: Initia carminum (Nummer)</xsl:when>
                    <xsl:when test="tei:abbr = 'Walther II'"><span class="author">Walther</span> II: Proverbia (Nummer, 1. und 2. Teil werden durchgezählt)</xsl:when>
                    <xsl:otherwise><xsl:value-of select="tei:abbr"/></xsl:otherwise>
                </xsl:choose>
            </term>
            <index>
                <xsl:choose>
                    <xsl:when test="tei:abbr[.='AH'] or tei:abbr[.='Mone']">
                        <term>
                            <!--<xsl:attribute name="sortKey" select="normalize-space(substring-before(text()[1], 'Nr. '))"/>-->
                            <xsl:value-of select="normalize-space(substring-before(text()[1], 'Nr. '))"/>
                        </term>
                        <index>
                            <term>
                                <!--<xsl:attribute name="sortKey" select="translate(substring-after(text()[1], 'Nr. '), $toBeReplaced, $replacedBy)"/>-->
                                <xsl:value-of select="concat('Nr. ', translate(substring-after(text()[1], 'Nr. '), $toBeReplaced, $replacedBy))"/>
                            </term>
                            <xsl:call-template name="writeIdno"/>
                        </index>
                    </xsl:when>
                    <xsl:otherwise>
                        <term>
                            <!--<xsl:attribute name="sortKey" select="translate(normalize-space(text()[1]), $toBeReplaced, $replacedBy)"/>-->
                            <xsl:value-of select="translate(normalize-space(text()[1]), $toBeReplaced, $replacedBy)"/>
                        </term>
                        <xsl:call-template name="writeIdno"/>
                    </xsl:otherwise>
                </xsl:choose>
            </index>
        </index>
    </xsl:template>

    <xsl:template match="tei:colophon" mode="Register">
        <index>
            <term>
                <xsl:attribute name="sortKey" select=" 'kolophon' "/>
                <xsl:text>Kolophon</xsl:text>
            </term>
            <xsl:call-template name="writeIdno"/>
        </index>
    </xsl:template>

    <xsl:template match="tei:handNote" mode="Register">
        <xsl:param name="addInfo"/>
        <xsl:param name="cert"/>
        <xsl:variable name="person" select="doc($listPerson)//tei:person[@xml:id=substring(current()/@scribeRef,2)]"/>
        <xsl:choose>
            <!-- ===== $addInfo ===== -->
            <xsl:when test="($addInfo != '')">
                <xsl:choose>
                    <!-- ===== tei:person/@xml:id ===== -->
                    <xsl:when test="exists(@scribeRef) and starts-with(@scribeRef, '#') and $person != '' ">
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="translate($person/@sortKey, ' /()?,;.:&lt;&gt;', '_-')"/>
                                <xsl:value-of select="$person/tei:persName[1]"/>
                                <xsl:if test="$person/tei:occupation">
                                    <xsl:text>, </xsl:text>
                                    <xsl:value-of select="$person/tei:occupation"/>
                                </xsl:if>
                            </term>
                            <span class="addInfo"><xsl:value-of select="$addInfo"/></span>
                            <xsl:call-template name="writeIdno"/>
                            <xsl:if test="@cert != ''"><span class="cert"> (?)</span></xsl:if>
                        </index>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="tei:index" mode="Register">
        <index>
            <xsl:choose>
                <xsl:when test="contains(tei:term, ' siehe ')">
                    <xsl:apply-templates mode="Register"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates mode="Register"/>
                    <xsl:if test="not(tei:index)"><xsl:call-template name="writeIdno"/></xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </index>
        <xsl:if test="contains(tei:term, 'Palimpsest')">
            <index>
                <term>
                    <xsl:attribute name="sortKey" select=" 'palimpsest' "/>
                    <xsl:text>Palimpsest</xsl:text>
                </term>
                <xsl:call-template name="writeIdno"/>
            </index>
        </xsl:if>
        
        <!-- to do?
            <xsl:for-each select="current-group()/ancestor::tei:accMat/tei:locus[not(.=preceding-sibling::tei:locus)]">
            <xsl:if test="not(starts-with(current-grouping-key(), 'Augustiner-Chorherren, ')) and not(starts-with(current-grouping-key(), 'Benediktiner, '))">
            <xsl:when test="ancestor::tei:index/tei:term[.='Provenienz II (Vorbesitzer)']"/>
            <xsl:for-each select="current-group()/parent::node()[not(ancestor::tei:binding)]/tei:locus[1]">
        -->
    </xsl:template>

    <xsl:template match="tei:msPart" mode="Register">
        <index>
            <term>
                <xsl:attribute name="sortKey" select=" 'fragmente' "/>
                <xsl:text>Fragmente</xsl:text>
            </term>
            <xsl:call-template name="writeIdno"/>
        </index>
    </xsl:template>

    <xsl:template match="tei:origDate" mode="Register">
        <index>
            <term>
                <xsl:if test="@notBefore"><xsl:attribute name="notBefore" select="@notBefore"/></xsl:if>
                <xsl:if test="@notAfter"><xsl:attribute name="notAfter" select="@notAfter"/></xsl:if>
                <xsl:apply-templates mode="Register"/>
            </term>
            <xsl:call-template name="writeIdno"/>
        </index>
    </xsl:template>

    <xsl:template match="tei:origPlace" mode="Register">
        <xsl:param name="addInfo"/>
        <xsl:variable name="org" select="doc($listOrg)//tei:org[@xml:id = substring(current()/@ref, 2)]"/>
        <xsl:variable name="place" select="doc($listPlace)//tei:place[@xml:id = substring(current()/@ref, 2)]"/>
        <xsl:variable name="orgName" select="doc($listOrg)//tei:org[concat(tei:settlement, ', ', tei:orgName[1])=current()]"/>
        <xsl:variable name="placeName" select="doc($listPlace)//tei:place[tei:placeName[1]=current()]"/>
        <!--<xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>-->
        <xsl:choose>
            <!-- ===== tei:place/@xml:id ===== -->
            <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $place[. != ''][tei:country and tei:region]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($place/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$place/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($place/tei:region), ' ', '_')"/>
                            <xsl:value-of select="$place/tei:region"/>
                        </term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="translate(lower-case($place/tei:placeName[1]), ' ', '_')"/>
                                <xsl:value-of select="$place/tei:placeName[1]"/>
                            </term>
                            <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                            <xsl:call-template name="writeIdno"/>
                        </index>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $place[. != ''][tei:country]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($place/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$place/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($place/tei:placeName[1]), ' ', '_')"/>
                            <xsl:value-of select="$place/tei:placeName[1]"/>
                        </term>
                        <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                        <xsl:call-template name="writeIdno"/>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $place[. != '']">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($place/tei:placeName[1]), ' ', '_')"/>
                        <xsl:value-of select="$place/tei:placeName[1]"/>
                    </term>
                    <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                    <xsl:call-template name="writeIdno"/>
                </index>
            </xsl:when>
            <!-- ===== tei:org/@xml:id ===== -->
            <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $org[. != ''][tei:country and tei:region]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($org/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$org/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($org/tei:region), ' ', '_')"/>
                            <xsl:value-of select="$org/tei:region"/>
                        </term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="translate(lower-case($org/tei:orgName[1]), ' ', '_')"/>
                                <xsl:value-of select="$org/tei:orgName[1]"/>
                            </term>
                            <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                            <xsl:call-template name="writeIdno"/>
                        </index>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $org[. != ''][tei:country]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($org/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$org/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($org/tei:orgname[1]), ' ', '_')"/>
                            <xsl:value-of select="$org/tei:orgName[1]"/>
                        </term>
                        <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                        <xsl:call-template name="writeIdno"/>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $org[. != '']">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($org/tei:orgName[1]), ' ', '_')"/>
                        <xsl:value-of select="$org/tei:orgName[1]"/>
                    </term>
                    <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                    <xsl:call-template name="writeIdno"/>
                </index>
            </xsl:when>
            <!-- ===== tei:place/tei:placeName ===== -->
            <xsl:when test="$placeName[. != ''][tei:country and tei:region]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($placeName/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$placeName/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($placeName/tei:region), ' ', '_')"/>
                            <xsl:value-of select="$placeName/tei:region"/>
                        </term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="translate(lower-case($placeName/tei:placeName[1]), ' ', '_')"/>
                                <xsl:value-of select="$placeName/tei:placeName[1]"/>
                            </term>
                            <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                            <xsl:call-template name="writeIdno"/>
                        </index>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="$placeName[. != ''][tei:country]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($placeName/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$placeName/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($placeName/tei:placeName[1]), ' ', '_')"/>
                            <xsl:value-of select="$placeName/tei:placeName[1]"/>
                        </term>
                        <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                        <xsl:call-template name="writeIdno"/>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="$placeName[. != '']">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($placeName/tei:placeName[1]), ' ', '_')"/>
                        <xsl:value-of select="$placeName/tei:placeName[1]"/>
                    </term>
                    <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                    <xsl:call-template name="writeIdno"/>
                </index>
            </xsl:when>
            <!-- ===== tei:org/tei:orgName ===== -->
            <xsl:when test="$orgName[. != ''][tei:country and tei:region and tei:settlement]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$orgName/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:region), ' ', '_')"/>
                            <xsl:value-of select="$orgName/tei:region"/>
                        </term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:settlement), ' ', '_')"/>
                                <xsl:value-of select="$orgName/tei:settlement"/>
                            </term>
                            <index>
                                <term>
                                    <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:orgName[1]), ' ', '_')"/>
                                    <xsl:value-of select="$orgName/tei:orgName[1]"/>
                                </term>
                                <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="$orgName[. != ''][tei:country and tei:settlement]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:country), ' ', '_')"/>
                        <xsl:value-of select="$orgName/tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:settlement), ' ', '_')"/>
                            <xsl:value-of select="$orgName/tei:settlement"/>
                        </term>
                        <index>
                            <term>
                                <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:orgName[1]), ' ', '_')"/>
                                <xsl:value-of select="$orgName/tei:orgName[1]"/>
                            </term>
                            <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                            <xsl:call-template name="writeIdno"/>
                        </index>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="$orgName[. != '']">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:settlement), ' ', '_')"/>
                        <xsl:value-of select="$orgName/tei:settlement"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case($orgName/tei:orgName[1]), ' ', '_')"/>
                            <xsl:value-of select="$orgName/tei:orgName[1]"/>
                        </term>
                        <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                        <xsl:call-template name="writeIdno"/>
                    </index>
                </index>
            </xsl:when>
            <xsl:when test="doc($listOrg)//tei:org[tei:orgName[1]=current()]">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case(doc($listOrg)//tei:org[tei:orgName[1]=current()]/tei:orgName[1]), ' ', '_')"/>
                        <xsl:value-of select="doc($listOrg)//tei:org[tei:orgName[1]=current()]/tei:orgName[1]"/>
                    </term>
                    <xsl:if test="($addInfo != '')"><span class="addInfo"><xsl:value-of select="$addInfo"/></span></xsl:if>
                    <xsl:call-template name="writeIdno"/>
                </index>
            </xsl:when>
            <xsl:otherwise>
                <index>
                    <term>
                        <xsl:text>### keine Normdaten vorhanden! Bitte ergänzen! Unsicherheit bitte mit @cert="medium" kodieren! ### </xsl:text>
                        <xsl:value-of select="."/>
                    </term>
                    <xsl:call-template name="writeIdno"/>
                </index>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="tei:org" mode="Register">
        <xsl:param name="listCountry"/>
        <!-- label berücksichtigen?! -->
        <xsl:choose>
            <xsl:when test="tei:country and ($listCountry = 'yes')">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case(tei:country), ' ', '_')"/>
                        <xsl:value-of select="tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="if (tei:settlement) then translate(lower-case(concat(tei:settlement, '_', tei:orgName[1])), ' ', '_') else translate(lower-case(tei:orgName[1]), ' ', '_')"/>
                            <xsl:if test="tei:settlement">
                                <xsl:value-of select="concat(tei:settlement, ', ')"/>
                            </xsl:if>
                            <xsl:value-of select="tei:orgName[1]"/>
                        </term>
                    </index>
                </index>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="tei:settlement">
                    <xsl:value-of select="concat(tei:settlement, ', ')"/>
                </xsl:if>
                <xsl:value-of select="tei:orgName[1]"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="tei:person" mode="Register">
        <xsl:choose>
            <xsl:when test="tei:persName[@type='default']">
                <xsl:value-of select="tei:persName[@type='default']"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="tei:persName[1]"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="tei:occupation">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="tei:occupation"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="tei:place" mode="Register">
        <xsl:param name="listCountry"/>
        <xsl:choose>
            <xsl:when test="tei:country and ($listCountry='yes')">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select="translate(lower-case(tei:country), ' ', '_')"/>
                        <xsl:value-of select="tei:country"/>
                    </term>
                    <index>
                        <term>
                            <xsl:attribute name="sortKey" select="translate(lower-case(tei:placeName[1]), ' ', '_')"/>
                            <xsl:value-of select="tei:placeName[1]"/>
                        </term>
                    </index>
                </index>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="sortKey" select="translate(lower-case(tei:placeName[1]), ' ', '_')"/>
                <xsl:value-of select="tei:placeName[1]"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="tei:ref" mode="Register">
        <xsl:choose>
            <xsl:when test="(@type = 'biblical') and @cRef">
                <xsl:apply-templates select="normalize-space(text())" mode="Register"/>
                <xsl:text> &#x2013; (</xsl:text>
                <xsl:value-of select="translate(@cRef, '_.', '  ')"/>
                <xsl:text>)</xsl:text>
            </xsl:when>
            <xsl:when test="(@type = 'medieval') and @cRef">
                <xsl:apply-templates select="normalize-space(text())" mode="Register"/>
                <xsl:text> &#x2013; (</xsl:text>
                <xsl:value-of select="translate(@cRef, '_', ' ')"/>
                <xsl:text>)</xsl:text>
            </xsl:when>
            <xsl:when test="(@type = 'mss')">
                <xsl:variable name="pathToCollection">
                    <xsl:choose>
                        <xsl:when test="starts-with(@cRef, 'alv-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Haldensleben', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'b-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Berlin', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'brb-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Brandenburg', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'bs-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Braunschweig', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'dd-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Dresden', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'de-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Dessau', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'ef-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Erfurt', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'gan-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Gandersheim', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'goe-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Goettingen', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'gth-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Gotha', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'h-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Hannover', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'hb-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Bremen', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'hbs-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Halberstadt', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'he-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Helmstedt', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'hh-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Hamburg', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'hi-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Hildesheim', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'hl-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Luebeck', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'hm-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Hameln', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'ki-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Kiel', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'koet-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Koethen', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'lg-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Lueneburg', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'm-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Muenchen', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'n-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Nuernberg', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'ol-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Oldenburg', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'qlb-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Quedlinburg', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'we-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Weimar', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'wf-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Deutschland/Wolfenbuettel', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'a-') and not(contains(@cRef, '-extrav')) and not(contains(@cRef, '-novi'))"><xsl:value-of select="concat($pathToDescriptions, 'ed/Oesterreich', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'ch-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/Schweiz', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'us-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/USA', '/')"/></xsl:when>
                        <xsl:when test="starts-with(@cRef, 'privat-')"><xsl:value-of select="concat($pathToDescriptions, 'ed/privat-o-s-01', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-astron')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-astron', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-bell')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-bell', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-geom')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-geom', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-hist')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-hist', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-jur')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-jur', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-med')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-med', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-phys')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-phys', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-poet')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-poet', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, '-theol')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-theol', '/')"/></xsl:when>
                        <xsl:when test="matches(@cRef, '\d-musica-\d')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-musica', '/')"/></xsl:when>
                        <xsl:when test="matches(@cRef, '\d-quod-\d')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/a-quod', '/')"/></xsl:when>
                        <xsl:when test="matches(@cRef, '\df-helmst')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/h', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'musica-helmst')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/h-musica', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'quod-helmst')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/h-quod', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'quod-novi')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/m-qun', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'textb')"><xsl:value-of select="concat($pathToDescriptions, 'hss-in-drucken/textb', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'aug-2f')"><xsl:value-of select="concat($pathToDescriptions, 'aug-2f', '/')"/></xsl:when>
                        <xsl:when test="matches(@cRef, 'aug-\d+f')"><xsl:value-of select="concat($pathToDescriptions, 'aug-rest', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'ba')"><xsl:value-of select="concat($pathToDescriptions, 'ba', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'blank')"><xsl:value-of select="concat($pathToDescriptions, 'blank', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'gud-lat')"><xsl:value-of select="concat($pathToDescriptions, 'gud-lat', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'gud-graec')"><xsl:value-of select="concat($pathToDescriptions, 'gud-graec', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'extrav')"><xsl:value-of select="concat($pathToDescriptions, 'extrav', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'helmst')"><xsl:value-of select="concat($pathToDescriptions, 'helmst', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'leibniziana')"><xsl:value-of select="concat($pathToDescriptions, 'leibniziana', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'lessingiana')"><xsl:value-of select="concat($pathToDescriptions, 'lessingiana', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'mus-hdschr')"><xsl:value-of select="concat($pathToDescriptions, 'mus-hdschr', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'noviss-2f')"><xsl:value-of select="concat($pathToDescriptions, 'noviss-2f', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'noviss-4f')"><xsl:value-of select="concat($pathToDescriptions, 'noviss-4f', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'noviss-8f')"><xsl:value-of select="concat($pathToDescriptions, 'noviss-8f', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'noviss-12f')"><xsl:value-of select="concat($pathToDescriptions, 'noviss-12f', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'novi')"><xsl:value-of select="concat($pathToDescriptions, 'novi', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'weiss')"><xsl:value-of select="concat($pathToDescriptions, 'weiss', '/')"/></xsl:when>
                        <xsl:when test="contains(@cRef, 'ed')"><xsl:value-of select="concat($pathToDescriptions, 'ed', '/')"/></xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <xsl:variable name="description" select="if (exists(document(concat($pathToCollection, @cRef, '/tei-msDesc.xml')))) 
                    then doc(concat($pathToCollection, @cRef, '/tei-msDesc.xml')) 
                    else ''"/>
                <xsl:choose>
                    <xsl:when test="$description != ''">
                        <index>
                            <term>
                                <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:settlement"/>
                                <xsl:text>, </xsl:text>
                                <xsl:choose>
                                    <xsl:when test="($description//tei:msDesc/tei:msIdentifier/tei:repository = $ignoreInRepository)">
                                        <xsl:value-of select="concat($ignoreInRepository, ', ', $ignoreInIdnoPraefix)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:repository"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </term>
                            <index>
                                <term>
                                    <xsl:attribute name="sortKey" select="$description//tei:msDesc/tei:msIdentifier/tei:idno/@sortKey"/>
                                    <xsl:choose>
                                        <xsl:when test="$description//tei:msDesc/tei:msIdentifier/tei:repository = $ignoreInRepository">
                                            <xsl:value-of select="substring-after($description//tei:msDesc/tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix)"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:idno"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:when test="count(tokenize(@cRef, ',')) >= 3">
                        <index>
                            <term><xsl:value-of select="concat(tokenize(@cRef, ',')[1], ', ', tokenize(@cRef, ',')[2])"/></term>
                            <index>
                                <term><xsl:value-of select="substring-after(substring-after(@cRef, ','), ',')"/></term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:otherwise>
                        <index>
                            <term><xsl:value-of select="@cRef"/></term>
                        </index>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'ba')">
                <xsl:variable name="description" select="if (exists(document(concat($pathToDescriptions[.!=''], '/ba/', @cRef, '/tei-msDesc.xml')))) 
                    then doc(concat($pathToDescriptions[.!=''], '/ba/', @cRef, '/tei-msDesc.xml')) 
                    else ''"/>
                <xsl:choose>
                    <xsl:when test="$description != ''">
                        <index>
                            <term>
                                <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:settlement"/>
                                <xsl:text>, </xsl:text>
                                <xsl:choose>
                                    <xsl:when test="($description//tei:msDesc/tei:msIdentifier/tei:repository = $ignoreInRepository)">
                                        <xsl:value-of select="concat($ignoreInRepository, ', Bibliotheksarchiv')"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:repository"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </term>
                            <index>
                                <term>
                                    <xsl:attribute name="sortKey" select="$description//tei:msDesc/tei:msIdentifier/tei:idno/@sortKey"/>
                                    <xsl:choose>
                                        <xsl:when test="$description//tei:msDesc/tei:msIdentifier/tei:repository = $ignoreInRepository">
                                            <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:idno"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$description//tei:msDesc/tei:msIdentifier/tei:idno"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:when test="count(tokenize(@cRef, ',')) >= 3">
                        <index>
                            <term><xsl:value-of select="concat(tokenize(@cRef, ',')[1], ', ', tokenize(@cRef, ',')[2])"/></term>
                            <index>
                                <term><xsl:value-of select="substring-after(substring-after(@cRef, ','), ',')"/></term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:otherwise>
                        <index>
                            <term><xsl:value-of select="@cRef"/></term>
                        </index>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'object')">
                <xsl:choose>
                    <xsl:when test="count(tokenize(@cRef, ',')) >= 3">
                        <index>
                            <term><xsl:value-of select="concat(tokenize(@cRef, ',')[1], ', ', tokenize(@cRef, ',')[2])"/></term>
                            <index>
                                <term><xsl:value-of select="substring-after(substring-after(@cRef, ','), ',')"/></term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:when test="count(tokenize(., ',')) >= 3">
                        <index>
                            <term><xsl:value-of select="concat(tokenize(., ',')[1], ', ', tokenize(., ',')[2])"/></term>
                            <index>
                                <term><xsl:value-of select="substring-after(substring-after(., ','), ',')"/></term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:otherwise>
                        <index>
                            <term><xsl:value-of select="@cRef"/></term>
                        </index>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'altMs')">
                <xsl:choose>
                    <xsl:when test="count(tokenize(., ',')) >= 3">
                        <index>
                            <term><xsl:value-of select="concat(tokenize(., ',')[1], ', ', tokenize(., ',')[2])"/></term>
                            <index>
                                <term><xsl:value-of select="substring-after(substring-after(., ','), ',')"/></term>
                                <xsl:call-template name="writeIdno"/>
                            </index>
                        </index>
                    </xsl:when>
                    <xsl:otherwise>
                        <index>
                            <term><xsl:value-of select="."/></term>
                            <xsl:call-template name="writeIdno"/>
                        </index>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="parent::tei:bibl and preceding-sibling::tei:abbr[.='Stegmüller RB']">
                <xsl:value-of select="."/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="tei:rs[not(@role = 'author') and not(@ref = ancestor::tei:msDesc/descendant::tei:author/@ref)]" mode="Register">
        <xsl:variable name="org" select="doc($listOrg)//tei:org[@xml:id = substring(current()/@ref, 2)]"/>
        <xsl:variable name="person" select="doc($listPerson)//tei:person[@xml:id = substring(current()/@ref, 2)]"/>
        <xsl:variable name="place" select="doc($listPlace)//tei:place[@xml:id = substring(current()/@ref, 2)]"/>
        <index>
            <term>
                <xsl:choose>
                    <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $person[. != '']">
                        <xsl:if test="$person/@sortKey">
                            <xsl:attribute name="sortKey" select="translate($person/@sortKey, ' /()?,;.:&lt;&gt;', '_-')"/>
                        </xsl:if>
                        <xsl:apply-templates select="$person" mode="Register"/>
                    </xsl:when>
                    <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $org[. != '']">
                        <xsl:if test="$org/@sortKey">
                            <xsl:attribute name="sortKey" select="translate($org/@sortKey, ' /()?,;.:&lt;&gt;', '_-')"/>
                        </xsl:if>
                        <xsl:apply-templates select="$org" mode="Register"/>
                    </xsl:when>
                    <xsl:when test="exists(@ref) and starts-with(@ref, '#') and $place[. != '']">
                        <xsl:if test="$place/@sortKey">
                            <xsl:attribute name="sortKey" select="translate($place/@sortKey, ' /()?,;.:&lt;&gt;', '_-')"/>
                        </xsl:if>
                        <xsl:apply-templates select="$place" mode="Register"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="sortKey" select="translate(., ' /()?,;.:&lt;&gt;', '_-')"/>
                        <xsl:value-of select="."/>
                    </xsl:otherwise>
                </xsl:choose>
                <!--<xsl:call-template name="writeEntity">
                    <xsl:with-param name="value">
                        <xsl:choose>
                            <xsl:when test="starts-with(@ref, '#')"><xsl:value-of select="substring(@ref, 2)"/></xsl:when>
                            <xsl:when test="@ref"><xsl:value-of select="@ref"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>-->
            </term>
            <xsl:if test="@role or (
                parent::tei:quote or 
                parent::tei:incipit or 
                parent::tei:explicit or 
                parent::tei:rubric or 
                parent::tei:finalRubric or 
                parent::tei:colophon)">
                <span class="addInfo">
                    <xsl:choose>
                        <xsl:when test="@role = 'owner_previous'"><xsl:text> (P)</xsl:text></xsl:when>
                        <xsl:when test="@role = 'scribe'"><xsl:text> (S)</xsl:text></xsl:when>
                        <xsl:when test="@role = 'translator'"><xsl:text> (Ü)</xsl:text></xsl:when>
                    </xsl:choose>
                    <xsl:if test="parent::tei:quote or 
                        parent::tei:incipit or 
                        parent::tei:explicit or 
                        parent::tei:rubric or 
                        parent::tei:finalRubric or 
                        parent::tei:colophon">
                        <xsl:text> (erwähnt) </xsl:text>
                    </xsl:if>
                </span>
            </xsl:if>
            <xsl:call-template name="writeIdno"/>
        </index>
    </xsl:template>

    <xsl:template match="tei:term" mode="Register">
        <term>
            <xsl:choose>
                <xsl:when test="ancestor::tei:index[@indexName = 'initien']
                       [not(preceding-sibling::tei:incipit[not(normalize-space(.)='')][not(@type='notInRegister')]) 
                    and not(preceding-sibling::tei:quote[(@type='incipit') or tei:lg][not(normalize-space(.)='')][not(@type='notInRegister')])]">
                    <xsl:if test="@xml:lang and (@xml:lang != 'la')"><xsl:attribute name="lang" select="@xml:lang"/></xsl:if>
                    <xsl:text>*</xsl:text>
                    <xsl:apply-templates mode="Register"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="@xml:lang and (@xml:lang != 'la')"><xsl:attribute name="lang" select="@xml:lang"/></xsl:if>
                    <xsl:choose>
                        <xsl:when test=" @type = 'author' ">
                            <xsl:variable name="person" select="doc($listPerson)//tei:person[@xml:id[.=substring(current()/@ref,2)]]"/>
                            <xsl:attribute name="sortKey" select="translate($person/@sortKey, ' /()?,;.:&lt;&gt;', '_-')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:attribute name="sortKey" select="lower-case(translate(., ' /()?,;.:&lt;&gt;', '_-'))"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:apply-templates mode="Register"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test=".='Liturgische Feste, besondere'">
                <xsl:text> (siehe auch: Officium, Reimoffizium)</xsl:text>
            </xsl:if>
        </term>
    </xsl:template>

    <xsl:template match="tei:title[not(@type='sub')]" mode="Register">
        <xsl:if test="not(starts-with(., 'Biblia sacra') and parent::tei:msItem/descendant::tei:index/tei:term[. = 'Biblia'])">
            <index>
                <term>
                    <xsl:attribute name="sortKey" select="translate(text()[1], ' /()?,;.:&lt;&gt;', '_-')"/>
                    <xsl:apply-templates mode="Register" select="node()[not(self::tei:note)]"/>
                </term>
                <xsl:call-template name="writeIdno"/>
            </index>
            <xsl:if test="contains(., 'Palimpsest')">
                <index>
                    <term>
                        <xsl:attribute name="sortKey" select=" 'palimpsest' "/>
                        <xsl:text>Palimpsest</xsl:text>
                    </term>
                    <xsl:call-template name="writeIdno"/>
                </index>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template match="term">
        <xsl:copy-of select="text() | *"/>
    </xsl:template>
    
    <xsl:template match="text()" mode="Register">
        <xsl:value-of select="normalize-space(.)"/>
    </xsl:template>

    <!-- ========== named templates ========== -->
    <!-- ===================================== -->

    <xsl:template name="writeFinalIndex">
        <xsl:param name="temporalIndex"/>
        <xsl:param name="indexName"/>
        <xsl:variable name="toBeReplaced"> /()?,;.:&lt;&gt;&apos;[]*</xsl:variable>
        <xsl:variable name="replacedBy">_-</xsl:variable>
        <xsl:if test="$mode = 'test'">
            <xsl:result-document href="{$pathToTestfiles}/temporalIndex/{translate($indexName, ' /()?,;.:&lt;&gt;', '_-')}.xml">
                <xsl:copy-of select="$temporalIndex"/>
            </xsl:result-document>
        </xsl:if>
        <xsl:for-each-group select="$temporalIndex/list/index" group-by="term">
            <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="term/@notBefore"/>
            <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="term/@notAfter"/>
            <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="term/@sortKey"/>
            <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="
                if (starts-with(current-grouping-key(), 'Ps.-')) then lower-case(translate(concat(substring-after(current-grouping-key(), 'Ps.-'), '-Ps'), $toBeReplaced, $replacedBy)) 
                else if (starts-with(current-grouping-key(), 'ps-'))  then lower-case(translate(concat(substring-after(current-grouping-key(), 'ps-'), '-Ps'), $toBeReplaced, $replacedBy))
                else lower-case(translate(current-grouping-key(), $toBeReplaced, $replacedBy))"/>
            <li>
                <xsl:choose>
                    <xsl:when test="(term/@lang != 'la') and (term/@lang != 'lat')">
                        <span class="italic"><xsl:apply-templates select="term"/></span>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="term"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text> </xsl:text>
                <xsl:for-each-group select="current-group()/span[@class = 'addInfo']" group-by=".">
                    <xsl:copy-of select="normalize-space(current-grouping-key())"/>
                </xsl:for-each-group>
                <xsl:text> </xsl:text>
                <xsl:for-each-group select="current-group()/span[@class = 'idno']" group-by=".">
                    <xsl:sort select="@sortKey"/>
                    <xsl:text> </xsl:text>
                    <xsl:choose>
                        <xsl:when test="$media != 'print-offline'">
                            <span class="idno"><a href="#{@n}"><xsl:value-of select="current-grouping-key()"/></a></span>
                        </xsl:when>
                        <xsl:otherwise>
                            <span class="idno"><xsl:value-of select="current-grouping-key()"/></span>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:for-each-group select="current-group()/following-sibling::span[@class = 'folio']" group-by=".">
                        <xsl:text>, </xsl:text>
                        <xsl:copy-of select="normalize-space(current-grouping-key())"/>
                    </xsl:for-each-group>
                    <xsl:for-each-group select="current-group()/following-sibling::span[@class = 'cert'][. != '']" group-by=".">
                        <xsl:text> </xsl:text>
                        <xsl:copy-of select="normalize-space(current-grouping-key())"/>
                    </xsl:for-each-group>
                    <xsl:if test="not(position() = last()) and not(ends-with(current-grouping-key(), '.'))">
                        <xsl:text>.</xsl:text>
                    </xsl:if>
                </xsl:for-each-group>
                <xsl:if test="current-group()/index">
                    <xsl:call-template name="processTemporalTree">
                        <xsl:with-param name="temporalTree">
                            <xsl:copy-of select="current-group()/index"/>
                        </xsl:with-param>
                        <xsl:with-param name="indexName" select="concat($indexName, '_', current-grouping-key())"/>
                        <xsl:with-param name="current-grouping-key" select="current-grouping-key()"/>
                    </xsl:call-template>
                </xsl:if>
            </li>
        </xsl:for-each-group>
    </xsl:template>

    <xsl:template name="processTemporalTree">
        <xsl:param name="temporalTree"/>
        <xsl:param name="indexName"/>
        <xsl:param name="current-grouping-key"/>
        <xsl:variable name="toBeReplaced"> /()?,;.:&lt;&gt;&apos;[]*</xsl:variable>
        <xsl:variable name="replacedBy">_-</xsl:variable>
        <xsl:if test="$mode = 'test'">
            <xsl:result-document href="{$pathToTestfiles}/temporalTree/{translate($indexName, ' /()?,;.:&lt;&gt;', '_-')}.xml">
                <xsl:copy-of select="$temporalTree"/>
            </xsl:result-document>
        </xsl:if>
        <ul>
            <xsl:for-each-group select="$temporalTree/index" group-by="term">
                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="term/@notBefore"/>
                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="term/@notAfter"/>
                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="term/@sortKey"/>
                <!--<xsl:sort collation="http://saxon.sf.net/collation?rules={encode-for-uri($sortRuleForBiblicalBooks)}">-->
                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes">
                    <xsl:choose>
                        <xsl:when test="starts-with(current-grouping-key(), 'IV ')">
                            <xsl:value-of select="lower-case(translate(concat(substring-after(current-grouping-key(), 'IV '), '4'), $toBeReplaced, $replacedBy))"/>
                        </xsl:when>
                        <xsl:when test="starts-with(current-grouping-key(), 'III ')">
                            <xsl:value-of select="lower-case(translate(concat(substring-after(current-grouping-key(), 'III '), '3'), $toBeReplaced, $replacedBy))"/>
                        </xsl:when>
                        <xsl:when test="starts-with(current-grouping-key(), 'II ')">
                            <xsl:value-of select="lower-case(translate(concat(substring-after(current-grouping-key(), 'II '), '2'), $toBeReplaced, $replacedBy))"/>
                        </xsl:when>
                        <xsl:when test="starts-with(current-grouping-key(), 'I ')">
                            <xsl:value-of select="lower-case(translate(concat(substring-after(current-grouping-key(), 'I '), '1'), $toBeReplaced, $replacedBy))"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="lower-case(translate(current-grouping-key(), $toBeReplaced, $replacedBy))"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:sort>
                <li>
                    <xsl:choose>
                        <xsl:when test="(term/@lang != 'la') and (term/@lang != 'lat')">
                            <span class="italic"><xsl:value-of select="normalize-space(current-grouping-key())"/></span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="normalize-space(current-grouping-key())"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text> </xsl:text>
                    <xsl:for-each-group select="current-group()/span[@class = 'addInfo']" group-by=".">
                        <xsl:copy-of select="current-grouping-key()"/>
                    </xsl:for-each-group>
                    <xsl:text> </xsl:text>
                    <xsl:for-each-group select="current-group()/span[@class = 'idno']" group-by=".">
                        <xsl:sort select="@sortKey"/>
                        <xsl:text> </xsl:text>
                        <xsl:choose>
                            <xsl:when test="$media != 'print-offline'">
                                <span class="idno"><a href="#{@n}"><xsl:value-of select="current-grouping-key()"/></a></span>
                            </xsl:when>
                            <xsl:otherwise>
                                <span class="idno"><xsl:value-of select="current-grouping-key()"/></span>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:for-each-group select="current-group()/following-sibling::span[@class = 'folio']" group-by=".">
                            <xsl:text>, </xsl:text>
                            <xsl:copy-of select="current-grouping-key()"/>
                        </xsl:for-each-group>
                        <xsl:for-each-group select="current-group()/span[@class = 'addInfo']" group-by=".">
                            <xsl:text> </xsl:text>
                            <xsl:copy-of select="current-grouping-key()"/>
                        </xsl:for-each-group>
                        <xsl:if test="not(position() = last()) and not(ends-with(current-grouping-key(), '.'))">
                            <xsl:text>.</xsl:text>
                        </xsl:if>
                    </xsl:for-each-group>
                    <xsl:if test="current-group()/index">
                        <xsl:call-template name="processTemporalTree">
                            <xsl:with-param name="temporalTree">
                                <xsl:copy-of select="current-group()/index"/>
                            </xsl:with-param>
                            <xsl:with-param name="indexName" select="concat($indexName, '_', current-grouping-key())"/>
                            <xsl:with-param name="current-grouping-key" select="current-grouping-key()"/>
                        </xsl:call-template>
                    </xsl:if>
                </li>
            </xsl:for-each-group>
        </ul>
    </xsl:template>

    <xsl:template name="writeCitedMss">
        <xsl:variable name="temporalIndex">
            <xsl:apply-templates mode="Register" select="root()/descendant::tei:ref[(@type = 'mss') or (@type = 'altMs') or (@type = 'ba') or (@type = 'object')]"/>
            <xsl:apply-templates mode="Register" select="root()/descendant::tei:index[tei:term[.='Handschriften, erwähnte']]"/>
        </xsl:variable>
        <xsl:copy-of select="$temporalIndex"/>
    </xsl:template>
                

    <xsl:template name="writeEntity">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="starts-with($value, 'http://')">
                <xsl:value-of select="."/>
            </xsl:when>
            <xsl:when test="descendant::*[self::tei:person or self::tei:place or self::tei:org][@xml:id[. = $value]]">
                <xsl:apply-templates mode="Register" select="//*[self::tei:person or self::tei:place or self::tei:org][@xml:id = $value]">
                    <xsl:with-param name="index" select=" 'yes' "/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="doc($listPerson)//tei:person[@xml:id=$value]">
                <xsl:apply-templates mode="Register" select="doc($listPerson)//tei:person[@xml:id = $value]">
                    <xsl:with-param name="index" select=" 'yes' "/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="doc($listPlace)//tei:place[@xml:id=$value]">
                <xsl:apply-templates mode="Register" select="doc($listPlace)//tei:place[@xml:id = $value]">
                    <xsl:with-param name="listCountry" select="'no'"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="doc($listOrg)//tei:org[@xml:id=$value]">
                <xsl:apply-templates mode="Register" select="doc($listOrg)//tei:org[@xml:id = $value]">
                    <xsl:with-param name="listCountry" select="'no'"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="contains($value, '_') and not($mode = 'test')">
                <xsl:value-of select="translate($value, '_#', ' ')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$value"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="writeIdno">
        <xsl:variable name="xmlid" select="substring-before(substring-after(ancestor::tei:msDesc/@xml:id, 'mss_'), '_')"/>
        <xsl:variable name="catNo" select="if (ancestor::tei:div[tei:head[. = 'Einleitung']]) then '' else count(preceding::tei:msDesc) + 1"/>
        <!--<xsl:variable name="sortKey">
            <xsl:choose>
                <xsl:when test="($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum')">
                    <xsl:value-of select="number($catNo)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="ancestor::tei:msDesc/tei:msIdentifier/tei:idno/@sortKey"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>-->
        <span class="idno" n="{$xmlid}"><!--  sortKey="{$sortKey}" -->
            <xsl:choose>
                <xsl:when test="($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum')">
                    <xsl:value-of select="$catNo"/>
                    <xsl:if test="ancestor::tei:msDesc"><xsl:text> (</xsl:text></xsl:if>
                    <xsl:call-template name="writeIdno_text"/>
                    <xsl:if test="ancestor::tei:msDesc"><xsl:text>)</xsl:text></xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="writeIdno_text"/>
                </xsl:otherwise>
            </xsl:choose>
        </span>
        <xsl:if test="@cert != ''"><span class="cert"> (?)</span></xsl:if>
        <xsl:choose>
            <xsl:when test="($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum')">
                <xsl:if test="(ancestor::tei:msItem[tei:locusGrp or tei:locus]                                 and (not(ancestor::tei:note[not(parent::tei:title)]) or ancestor-or-self::tei:bibl))
                    or (ancestor::tei:msItem[1][preceding-sibling::tei:msItem[1][tei:locusGrp or tei:locus]]   and (not(ancestor::tei:note[not(parent::tei:title)]) or ancestor-or-self::tei:bibl))
                    or (self::tei:msPart and descendant::tei:msItem[tei:locusGrp or tei:locus])">
                    <xsl:call-template name="writeLocus"/>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="tei:locusGrp or tei:locus 
                    or ((preceding-sibling::tei:locusGrp or preceding-sibling::tei:locus)                      and (not(ancestor::tei:note[not(parent::tei:title)]) or ancestor-or-self::tei:bibl)) and (not(ancestor::tei:binding) and not(ancestor::tei:foliation)) 
                    or ((ancestor::tei:index[preceding-sibling::tei:locusGrp or preceding-sibling::tei:locus]) and (not(ancestor::tei:note[not(parent::tei:title)]) or ancestor-or-self::tei:bibl)) and (not(ancestor::tei:binding) and not(ancestor::tei:foliation))
                    or (ancestor::tei:msItem[tei:locusGrp or tei:locus]                                        and (not(ancestor::tei:note[not(parent::tei:title)]) or ancestor-or-self::tei:bibl))
                    or (ancestor::tei:msItem[1][preceding-sibling::tei:msItem[1][tei:locusGrp or tei:locus]]   and (not(ancestor::tei:note[not(parent::tei:title)]) or ancestor-or-self::tei:bibl))
                    or (self::tei:msPart and descendant::tei:msItem[tei:locusGrp or tei:locus])">
                    <xsl:call-template name="writeLocus"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="writeIdno_text">
        <xsl:choose>
            <xsl:when test="ancestor::tei:div[tei:head[. = 'Einleitung']]">
                <!--<xsl:text>Einleitung</xsl:text>-->
                <xsl:value-of select="concat('S. ', preceding::tei:pb[1]/@n)"/>
            </xsl:when>
            <xsl:when test="($ignoreInIdnoPraefix != '') and ($ignoreInIdno != '')">
                <xsl:value-of select="normalize-space(replace(replace(ancestor::tei:msDesc/tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix, ''), $ignoreInIdno, ''))"/>
            </xsl:when>
            <xsl:when test="($ignoreInIdnoPraefix != '')">
                <xsl:value-of select="normalize-space(replace(ancestor::tei:msDesc/tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix, ''))"/>
            </xsl:when>
            <xsl:when test="($ignoreInIdno != '')">
                <xsl:value-of select="normalize-space(replace(ancestor::tei:msDesc/tei:msIdentifier/tei:idno, $ignoreInIdno, ''))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="normalize-space(ancestor::tei:msDesc/tei:msIdentifier/tei:idno)"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="ancestor::tei:msPart">
            <xsl:value-of select="concat(' [', ancestor::tei:msPart/tei:msIdentifier/tei:idno, ']')"/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="writeLocus">
        <span class="folio">
            <xsl:choose>
                <xsl:when test="tei:locusGrp">
                    <xsl:apply-templates select="tei:locusGrp/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="tei:locus">
                    <xsl:apply-templates select="tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="preceding-sibling::tei:locusGrp">
                    <xsl:apply-templates select="preceding-sibling::tei:locusGrp[1]/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="preceding-sibling::tei:locus">
                    <xsl:apply-templates select="preceding-sibling::tei:locus[1]">
                        <xsl:with-param name="context" select="local-name()"/>
                        <xsl:with-param name="index" select=" 'yes' "/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="ancestor::tei:index[preceding-sibling::tei:locusGrp]">
                    <xsl:apply-templates select="ancestor::tei:index/preceding-sibling::tei:locusGrp[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="ancestor::tei:index[preceding-sibling::tei:locus]">
                    <xsl:apply-templates select="ancestor::tei:index/preceding-sibling::tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="ancestor::tei:msItem[1][tei:locusGrp]">
                    <xsl:apply-templates select="ancestor::tei:msItem[1][tei:locusGrp]/tei:locusGrp/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="ancestor::tei:msItem[1][tei:locus]">
                    <xsl:apply-templates select="ancestor::tei:msItem[1][tei:locus]/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="ancestor::tei:msItem[1][preceding-sibling::tei:msItem[1][tei:locusGrp]]">
                    <xsl:apply-templates select="ancestor::tei:msItem[1]/preceding-sibling::tei:msItem[1][tei:locusGrp]/tei:locusGrp/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="ancestor::tei:msItem[1][preceding-sibling::tei:msItem[1][tei:locus]]">
                    <xsl:apply-templates select="ancestor::tei:msItem[1]/preceding-sibling::tei:msItem[1][tei:locus]/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="self::tei:msPart and descendant::tei:msItem/tei:locusGrp">
                    <xsl:apply-templates select="descendant::tei:msItem[1]/tei:locusGrp/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:when test="self::tei:msPart and descendant::tei:msItem/tei:locus">
                    <xsl:apply-templates select="descendant::tei:msItem[1]/tei:locus[1]">
                        <xsl:with-param name="index" select=" 'yes' "/>
                        <xsl:with-param name="context" select="local-name()"/>
                    </xsl:apply-templates>
                </xsl:when>
            </xsl:choose>
        </span>
    </xsl:template>

</xsl:stylesheet>