<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tei="http://www.tei-c.org/ns/1.0" exclude-result-prefixes="#all" version="2.0">

	<!-- version: 5.2 /2014-/ (c) Herzog August Bibliothek / schassan@hab.de -->

    <!-- falls das Skript lokal genutzt werden soll, bitte folgende Adresse eintragen: http://diglib.hab.de/rules/styles/mss/TEI-P5-to-Print/current/param.xsl -->
    <xsl:import href="http://exist.hab.de/rest/db/data/rules/styles/xsl/mss/TEI-P5-to-Print/param.xsl"/>
    <xsl:import href="http://exist.hab.de/rest/db/data/rules/styles/xsl/mss/TEI-P5-to-Print/generateIndices.xsl"/>
    <xsl:param name="lang"/>
    <!--<xsl:output method="html" encoding="UTF-8" indent="no" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>-->
    <xsl:strip-space elements="*"/>
    <xsl:param name="bibliography">
        <xsl:choose>
            <xsl:when test="//tei:list[@type = 'bibliography']">
                <xsl:copy-of select="//tei:list[@type = 'bibliography']"/>
            </xsl:when>
            <xsl:when test="not($listBibl = '')">
                <xsl:copy-of select="doc($listBibl)"/>
            </xsl:when>
        </xsl:choose>
    </xsl:param>
    <xsl:template match="/">
        <xsl:apply-templates select="descendant-or-self::tei:msDesc"/>
        <xsl:if test="($listAbbreviatedTitles = 'yes') and           $bibliography//tei:label[. = current()//tei:abbr[parent::tei:bibl[not(ancestor::tei:source)]][not(ancestor::tei:list[@type = 'bibliography'])]]">
            <xsl:call-template name="writeBibliography"/>
        </xsl:if>
        <xsl:if test="not($literaturDB='')">
            <xsl:call-template name="literaturDB">
                <xsl:with-param name="xmlid" select="tei:TEI/@xml:id"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="tei:TEI/tei:text[descendant::tei:div[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]]">
            <hr/>
            <xsl:apply-templates select="ancestor::tei:TEI/tei:text[descendant::tei:div][not(self::tei:msDesc)]"/>
        </xsl:if>
        <xsl:if test="descendant::tei:revisionDesc">
            <hr/>
            <xsl:apply-templates select="descendant::tei:revisionDesc"/>
        </xsl:if>
        <xsl:if test="descendant::tei:projectDesc">
            <hr/>
            <xsl:apply-templates select="descendant::tei:projectDesc"/>
        </xsl:if>
        <xsl:if test="descendant-or-self::tei:msDesc/tei:msIdentifier[tei:settlement[.='Wolfenbüttel']][tei:repository[.='Herzog August Bibliothek']]">
            <hr/>
            <div>
                <ul>
                    <li>
                        <xsl:choose>
                            <xsl:when test="$lang = 'en' ">
                                <a href="{concat($opac, $searchForTerm, '&#34;', translate(descendant-or-self::tei:msDesc/tei:msIdentifier/tei:idno, ' ', '+'), '&#34;')}">Search</a> the OPAC for further literature.</xsl:when>
                            <xsl:otherwise>Weitere Literaturnachweise im OPAC <a href="{concat($opac, $searchForTerm, '&#34;', translate(descendant::tei:msDesc/tei:msIdentifier/tei:idno, ' ', '+'), '&#34;')}">suchen</a>.</xsl:otherwise>
                        </xsl:choose>
                    </li>
                    <li>
                        <xsl:choose>
                            <xsl:when test="$lang = 'en' ">
                                <a href="{concat('?db=mss&amp;lang=en&amp;list=mssdoku&amp;id=', descendant-or-self::tei:msDesc/tei:msIdentifier/tei:idno)}">Search</a> for further entries in the research documentation.</xsl:when>
                            <xsl:otherwise>Weitere Literaturnachweise <a href="{concat('?db=mss&amp;list=mssdoku&amp;id=', descendant::tei:msDesc/tei:msIdentifier/tei:idno)}">suchen</a> (ehem. Handschriftendokumentation)</xsl:otherwise>
                        </xsl:choose>
                    </li>
                </ul>
            </div>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="//tei:publicationStmt/tei:availability[@status='restricted' and tei:p/tei:orgName]">
                <div class="rights">
                    <xsl:choose>
                        <xsl:when test="$lang = 'en' ">By courtesy of <xsl:apply-templates select="//tei:publicationStmt/tei:availability//tei:orgName"/>. The manuscript description is copyrighted by the publisher.</xsl:when>
                        <xsl:when test="$lang = 'fr' ">Avec l'aimable permission de <xsl:apply-templates select="//tei:publicationStmt/tei:availability//tei:orgName"/>. L'éditeur détient l'ensemble des droits de publication.</xsl:when>
                        <xsl:when test="$lang = 'it' ">Per gentile permissione di <xsl:apply-templates select="//tei:publicationStmt/tei:availability//tei:orgName"/>. Tutti diritti sono riservati all'Editore.</xsl:when>
                        <xsl:otherwise>Mit freundlicher Genehmigung des Verlags (<xsl:apply-templates select="//tei:publicationStmt/tei:availability//tei:orgName"/>). Das Copyright an der Handschriftenbeschreibung liegt beim Verlag.</xsl:otherwise>
                    </xsl:choose>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="rights">
                    <xsl:apply-templates select="//tei:publicationStmt/tei:availability"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="(($showIndex = 'yes') or ($showIndex = 'only')) and (         descendant::tei:accMat     or descendant::tei:author[parent::tei:msItem]     or descendant::tei:colophon     or descendant::tei:handNote[@scribe]     or descendant::tei:head/tei:title[contains(., 'Palimpsest')]     or descendant::tei:incipit      or descendant::tei:index     or descendant::tei:msFrag     or descendant::tei:origDate     or descendant::tei:origPlace     or descendant::tei:ref[(@type = 'mss') or (@type = 'altMs')]     or descendant::tei:rs[(@type = 'person') or (@type = 'place') or (@type = 'org') or (@type = 'corporate') or (@type = 'object')]     or descendant::tei:msIdentifier[parent::tei:bibl]     or descendant::tei:title[parent::tei:msItem]     ) ">
            <xsl:call-template name="generateIndices"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:*">
        <xsl:apply-templates/>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:abbr[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:choose>
            <xsl:when test="parent::tei:bibl">
                <span>
                    <xsl:attribute name="class">author</xsl:attribute>
                    <xsl:call-template name="resolveAbbr"/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="resolveAbbr"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template name="resolveAbbr">
        <xsl:choose>
            <xsl:when test="ancestor::tei:source">
                <xsl:value-of select="$bibliography//tei:list[@type = 'bibliography']/tei:item[tei:label=current()]/tei:bibl"/>
            </xsl:when>
            <xsl:when test="($listAbbreviatedTitles = 'yes') and contains($media,'print')">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="($listAbbreviatedTitles = 'yes') and parent::tei:bibl and    ((. = doc($listBibl)//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label) or    (@target = doc($listBibl)//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id))">
                <a>
                    <xsl:attribute name="href">
                        <xsl:text>?db=mss&amp;list=ms&amp;id=</xsl:text>
                        <xsl:value-of select="substring-before(substring-after(ancestor::tei:TEI/@xml:id, 'mss_'), '_tei-msDesc')"/>
                        <xsl:text>&amp;catalog=</xsl:text>
                        <xsl:value-of select="substring-after(ancestor::tei:TEI/@xml:id, 'tei-msDesc_')"/>
                        <xsl:text>#</xsl:text>
                        <xsl:value-of select="translate(doc($listBibl)//tei:list[@type = 'bibliography']/tei:item/tei:label[. = current()][1],' ()','_')"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="($listAbbreviatedTitles = 'yes') and parent::tei:bibl and    ((. = $bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label) or    (@target = $bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id))">
                <a>
                    <xsl:attribute name="href">
                        <xsl:text>?db=mss&amp;list=ms&amp;id=</xsl:text>
                        <xsl:value-of select="substring-before(substring-after(ancestor::tei:TEI/@xml:id, 'mss_'), '_tei-msDesc')"/>
                        <xsl:text>&amp;catalog=</xsl:text>
                        <xsl:value-of select="substring-after(ancestor::tei:TEI/@xml:id, 'tei-msDesc_')"/>
                        <xsl:text>#</xsl:text>
                        <xsl:value-of select="translate($bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item[tei:label = current()]/tei:label,' ()','_')"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="($listAbbreviatedTitles = 'no') and parent::tei:bibl and    ((. = $bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label) or     (@target = $bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id))">
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$opac"/>
                        <xsl:choose>
                            <xsl:when test=". = $bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label">
                                <xsl:value-of select="substring-after($bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item[tei:label=current()]/@xml:id,'opac_')"/>
                            </xsl:when>
                            <xsl:when test="@target = $bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id">
                                <xsl:value-of select="substring-after($bibliography//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item[@xml:id=current()/@target]/@xml:id,'opac_')"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:attribute>
                    <span>
                        <xsl:if test="self::tei:abbr">
                            <xsl:attribute name="class">author</xsl:attribute>
                        </xsl:if>
                        <xsl:apply-templates/>
                    </span>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:accMat[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:bindingDesc[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <p>
            <xsl:choose>
                <xsl:when test="($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum') ">
                    <xsl:attribute name="class">physDesc_illum</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">physDesc</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    <xsl:template match="tei:add[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <span>
            <xsl:attribute name="class">normal</xsl:attribute>
            <xsl:text>[</xsl:text>
            <xsl:choose>
                <xsl:when test="@place = 'supralinear' ">über der Zeile: </xsl:when>
            </xsl:choose>
        </span>
        <xsl:apply-templates/>
        <span>
            <xsl:attribute name="class">normal</xsl:attribute>
            <xsl:text>]</xsl:text>
        </span>
    </xsl:template>
    <xsl:template match="tei:additional[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:if test="tei:listBibl">
            <p>
                <xsl:attribute name="class">additional</xsl:attribute>
                <xsl:apply-templates select="tei:listBibl"/>
            </p>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:msIdentifier | tei:altIdentifier" mode="msPart">
        <p>
            <xsl:attribute name="class">part</xsl:attribute>
            <xsl:if test="tei:settlement != ancestor::tei:msDesc/tei:msIdentifier/tei:settlement">
                <xsl:value-of select="tei:settlement"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="tei:institution != ancestor::tei:msDesc/tei:msIdentifier/tei:institution">
                <xsl:value-of select="tei:institution"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="tei:repository != ancestor::tei:msDesc/tei:msIdentifier/tei:repository">
                <xsl:value-of select="tei:repository"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="tei:collection != ancestor::tei:msDesc/tei:msIdentifier/tei:collection">
                <xsl:value-of select="tei:collection"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:value-of select="tei:idno"/>
        </p>
    </xsl:template>
    <xsl:template match="tei:altIdentifier">
        <xsl:choose>
            <xsl:when test="@type = 'siglum'">
                <div>
                    <span>
                        <xsl:attribute name="class">head</xsl:attribute>Sigle: </span>
                    <xsl:apply-templates/>
                </div>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:altIdentifier[@type = 'former']  [not(@rend='doNotShow')]  [not(contains(preceding-sibling::tei:idno, 'olim')) and not(contains(preceding-sibling::tei:idno, tei:idno))]" mode="Schlagzeile">
        <xsl:if test="not(preceding-sibling::tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')])">
            <xsl:text>Alte Signatur: </xsl:text>
        </xsl:if>
        <xsl:if test="preceding-sibling::tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]">
            <xsl:text> / </xsl:text>
        </xsl:if>
        <xsl:apply-templates mode="Schlagzeile"/>
        <xsl:value-of select="$Trennzeichen"/>
    </xsl:template>
    <xsl:template match="tei:author[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:editor[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <span>
            <xsl:attribute name="class">author</xsl:attribute>
            <xsl:if test=" @rend = 'supplied' ">
                <xsl:text>[</xsl:text>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="parent::tei:bibl">
                    <xsl:choose>
                        <xsl:when test="contains(@n,concat($searchfield,'_'))">
                            <a>
                                <xsl:attribute name="target">_blank</xsl:attribute>
                                <xsl:attribute name="href">
                                    <xsl:value-of select="$opac"/>
                                    <xsl:choose>
                                        <xsl:when test="contains(substring-after(@n,concat($searchfield,'_')),';')">
                                            <xsl:value-of select="substring-before(substring-after(@n,concat($searchfield,'_')),';')"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="substring-after(@n,concat($searchfield,'_'))"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:attribute>
                                <xsl:apply-templates/>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
            <xsl:if test=" @rend = 'supplied' and not( following-sibling::tei:title[ @rend = 'supplied' ]) ">
                <xsl:text>]</xsl:text>
            </xsl:if>
        </span>
        <xsl:choose>
            <xsl:when test="following-sibling::tei:author and     not(starts-with(substring-after(..,.),',')) and     not(starts-with(substring-after(..,.),':')) and     not(starts-with(substring-after(..,.),'.')) and    not(contains(.,':'))">
                <xsl:text>, </xsl:text>
            </xsl:when>
            <xsl:when test="following-sibling::tei:title and     not(starts-with(substring-after(..,.),',')) and     not(starts-with(substring-after(..,.),':')) and     not(starts-with(substring-after(..,.),'.')) and    not(contains(.,':'))">
                <xsl:text>: </xsl:text>
            </xsl:when>
            <xsl:when test="not(following-sibling::node()[name() = current()/name()]) and parent::tei:msItem and    not(following-sibling::tei:title) and     not(starts-with(substring-after(..,.),',')) and     not(starts-with(substring-after(..,.),':')) and     not(starts-with(substring-after(..,.),'.')) and    not(contains(.,':'))">
                <xsl:text>. </xsl:text>
            </xsl:when>
            <xsl:when test="not(parent::tei:bibl) and preceding-sibling::tei:ptr and normalize-space(following-sibling::text()[1])">
                <xsl:call-template name="writeWhitespace"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:author[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="condensed">
        <span>
            <xsl:attribute name="class">author</xsl:attribute>
            <xsl:if test=" @rend = 'supplied' ">
                <xsl:text>[</xsl:text>
            </xsl:if>
            <xsl:apply-templates/>
            <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
            <xsl:if test=" @rend = 'supplied' and not( following-sibling::tei:title[ @rend = 'supplied' ]) ">
                <xsl:text>]</xsl:text>
            </xsl:if>
        </span>
        <xsl:choose>
            <xsl:when test="following-sibling::tei:author and     not(starts-with(substring-after(..,.),',')) and     not(starts-with(substring-after(..,.),':')) and     not(starts-with(substring-after(..,.),'.')) and    not(contains(.,':'))">
                <xsl:text>, </xsl:text>
            </xsl:when>
            <xsl:when test="following-sibling::tei:title and     not(starts-with(substring-after(..,.),',')) and     not(starts-with(substring-after(..,.),':')) and     not(starts-with(substring-after(..,.),'.')) and    not(contains(.,':'))">
                <xsl:text>: </xsl:text>
            </xsl:when>
            <xsl:when test="not(following-sibling::node()[name() = current()/name()]) and parent::tei:msItem and    not(following-sibling::tei:title) and     not(starts-with(substring-after(..,.),',')) and     not(starts-with(substring-after(..,.),':')) and     not(starts-with(substring-after(..,.),'.')) and    not(contains(.,':'))">
                <xsl:text>. </xsl:text>
            </xsl:when>
            <xsl:when test="not(parent::tei:bibl) and preceding-sibling::tei:ptr and normalize-space(following-sibling::text()[1])">
                <xsl:call-template name="writeWhitespace"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:bibl[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default condensed Einzeldatei meta msPart Schlagzeile Schlagzeile-illum Signatur">
        <xsl:choose>
            <xsl:when test=" ($showAllElements = 'yes') and (not(@rend='onlineOnly'))">
                <xsl:choose>
                    <xsl:when test="@xml:id and ($media != 'print-offline')">
                        <a>
                            <xsl:attribute name="name">
                                <xsl:value-of select="@xml:id"/>
                            </xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="contains(@xml:id,'opac')">
                                    <xsl:attribute name="href">
                                        <xsl:value-of select="concat($opac,substring-after(@xml:id,'opac_'))"/>
                                    </xsl:attribute>
                                </xsl:when>
                                <xsl:when test="contains(@xml:id,'gbv')">
                                    <xsl:attribute name="href">
                                        <xsl:value-of select="concat($gbv,substring-after(@xml:id,'gbv_'))"/>
                                    </xsl:attribute>
                                </xsl:when>
                            </xsl:choose>
                            <xsl:apply-templates/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:choose>
                    <xsl:when test="parent::tei:listBibl[ancestor::tei:additional] and following-sibling::tei:bibl[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] and         not(substring(.,string-length(.)-1)=';') and not(substring(.,string-length(.)-1)='.')">
                        <xsl:value-of select="$Trennzeichen"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="writeWhitespace"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:cell[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="(@role='label')">
                <th>
                    <xsl:attribute name="nowrap">nowrap</xsl:attribute>
                    <xsl:apply-templates/>
                </th>
            </xsl:when>
            <xsl:otherwise>
                <td>
                    <xsl:if test="contains(@rend,'nowrap')">
                        <xsl:attribute name="nowrap">nowrap</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates/>
                </td>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:choice">
        <xsl:apply-templates select="tei:orig | tei:sic"/>
        <span>
            <xsl:attribute name="class">normal</xsl:attribute>
            <xsl:text>[=</xsl:text>
            <xsl:apply-templates select="tei:reg | tei:corr"/>
            <xsl:text>]</xsl:text>
        </span>
    </xsl:template>
    <xsl:template match="tei:collation[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:choose>
            <xsl:when test="not(starts-with(.,'Lagen'))">
                <xsl:text>Lagen: </xsl:text>
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="writePunctuation"/>
    </xsl:template>
    <xsl:template match="tei:collection" mode="Schlagzeile"/>
    <xsl:template match="tei:colophon[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <span>
            <xsl:attribute name="class">colophon</xsl:attribute>
            <xsl:apply-templates/>
        </span>
        <xsl:call-template name="writePunctuation"/>
    </xsl:template>
    <xsl:template match="tei:date[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:apply-templates/>
        <xsl:if test="(parent::tei:rubric or parent::tei:incipit or parent::tei:quote or parent::tei:explicit or parent::tei:colophon or parent::tei:finalRubric) and not(contains(.,@when))">
            <span>
                <xsl:attribute name="class">normal</xsl:attribute>
                <xsl:text> [</xsl:text>
                <xsl:call-template name="writeDate">
                    <xsl:with-param name="date" select="@when"/>
                </xsl:call-template>
                <xsl:text>] </xsl:text>
            </span>
        </xsl:if>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:dimensions[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]][(@type = 'leaf')]" mode="Schlagzeile">
        <xsl:apply-templates/>
        <xsl:choose>
            <xsl:when test="@unit and not(tei:height/@unit) and not(tei:width/@unit) and not(tei:depth/@unit)">
                <xsl:value-of select="concat(' ',@unit)"/>
            </xsl:when>
            <xsl:when test="tei:height/@unit or tei:width/@unit"/>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:dimensions[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default">
        <xsl:if test="(@type = 'written') and not(contains(preceding-sibling::text()[1], 'Schriftraum'))">
            <xsl:text>Schriftraum: </xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="ancestor::tei:accMat or ancestor::tei:msPart[@rend = 'condensed'] or ancestor::tei:msFrag">
                <xsl:apply-templates mode="#current"/>
                <xsl:choose>
                    <xsl:when test="tei:height/@unit or tei:width/@unit or tei:depth/@unit"/>
                    <xsl:when test="@unit">
                        <xsl:value-of select="concat(' ', @unit)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'leaf') and parent::tei:extent[ancestor::tei:physDesc/parent::tei:msDesc]"/>
            <xsl:otherwise>
                <xsl:apply-templates mode="#current"/>
                <xsl:choose>
                    <xsl:when test="tei:height/@unit or tei:width/@unit or tei:depth/@unit"/>
                    <xsl:when test="@unit">
                        <xsl:value-of select="concat(' ', @unit)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(parent::tei:p) and not(parent::tei:decoNote)">
            <xsl:call-template name="writePunctuation"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:edition[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <sup>
            <xsl:apply-templates/>
        </sup>
        <xsl:if test="not(parent::tei:bibl)">
            <xsl:call-template name="writeWhitespace"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:ex">
        <span>
            <xsl:attribute name="class">normal</xsl:attribute>
            <xsl:text>[</xsl:text>
            <xsl:apply-templates/>
            <xsl:text>]</xsl:text>
        </span>
    </xsl:template>
    <xsl:template match="tei:explicit[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default condensed">
        <xsl:choose>
            <xsl:when test="starts-with(., tei:locus[1]) and (preceding-sibling::tei:incipit or contains(@rend, 'dottedBegin'))">
                <xsl:apply-templates select="node()[1][self::tei:locus]"/>
                <xsl:text> … </xsl:text>
            </xsl:when>
            <xsl:when test="preceding-sibling::tei:incipit or contains(@rend, 'dottedBegin')">
                <xsl:text> … </xsl:text>
            </xsl:when>
        </xsl:choose>
        <span>
            <xsl:attribute name="class">explicit</xsl:attribute>
            <xsl:apply-templates select="node()[not(self::tei:locus[not(preceding-sibling::node())])]"/>
        </span>
        <xsl:choose>
            <xsl:when test="contains(@rend, 'dottedEnd') or following-sibling::tei:explicit">
                <xsl:text> … </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="writePunctuation"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:extent"/>
    <xsl:template match="tei:extent[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile">
        <xsl:if test="(ancestor::tei:physDesc/preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]     and not(contains(ancestor::tei:physDesc/preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',ancestor::tei:physDesc/preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno))))    or     (ancestor::tei:physDesc/tei:objectDesc/tei:supportDesc/@material     or (normalize-space(ancestor::tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support//tei:material) != ''))">
            <xsl:value-of select="$Trennzeichen"/>
        </xsl:if>
        <xsl:value-of select="descendant::tei:measure[@type = 'leavesCount']"/>
        <xsl:choose>
            <xsl:when test="descendant::tei:measure[@type = 'leavesCount']     and descendant::tei:measure[(@type = 'pageDimensions') or (@type = 'leavesSize')]">
                <xsl:value-of select="$Trennzeichen"/>
                <xsl:value-of select="descendant::tei:measure[(@type = 'pageDimensions') or (@type = 'leavesSize')]"/>
            </xsl:when>
            <xsl:when test="descendant::tei:measure[@type = 'leavesCount']     and descendant::tei:dimensions[(@type = 'leaf')]">
                <xsl:value-of select="$Trennzeichen"/>
                <xsl:apply-templates select="descendant::tei:dimensions[(@type = 'leaf')]" mode="Schlagzeile"/>
            </xsl:when>
            <xsl:when test="descendant::tei:measure[@type = 'pageDimensions']">
                <xsl:apply-templates select="descendant::tei:measure[@type = 'pageDimensions']" mode="Schlagzeile"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:gap" mode="#all">
        <xsl:choose>
            <xsl:when test="@reason">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:attribute name="title">
                        <xsl:value-of select="@reason"/>
                    </xsl:attribute>
                    <xsl:text>…</xsl:text>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>…</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:head[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile">
        <p>
            <xsl:attribute name="class">schlagzeile</xsl:attribute>
            <xsl:choose>
                <xsl:when test="(tei:note[@type = 'caption'] != '')">
                    <xsl:value-of select="tei:note[@type = 'caption']"/>
                </xsl:when>
                <xsl:when test="tei:note and not(*[not(self::tei:note)])">
                    <xsl:apply-templates select="tei:note"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][not(contains(preceding-sibling::tei:idno, tei:idno))]">
                            <xsl:apply-templates select="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][not(contains(preceding-sibling::tei:idno, tei:idno))]" mode="Schlagzeile"/>
                        </xsl:when>
                        <xsl:when test="parent::tei:msPart">
                            <xsl:apply-templates select="preceding-sibling::tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]" mode="Schlagzeile"/>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:apply-templates select="following-sibling::tei:physDesc/descendant::tei:supportDesc" mode="Schlagzeile"/>
                    <xsl:choose>
                        <xsl:when test="(tei:origPlace != '')">
                            <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]         and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))        or following-sibling::tei:physDesc/descendant::tei:supportDesc">
                                <xsl:value-of select="$Trennzeichen"/>
                            </xsl:if>
                            <xsl:apply-templates select="tei:origPlace" mode="Schlagzeile"/>
                        </xsl:when>
                        <xsl:when test="(following-sibling::tei:history/tei:origin//tei:origPlace != '')">
                            <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]         and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))        or following-sibling::tei:physDesc/descendant::tei:supportDesc">
                                <xsl:value-of select="$Trennzeichen"/>
                            </xsl:if>
                            <xsl:apply-templates select="following-sibling::tei:history/tei:origin//tei:origPlace" mode="Schlagzeile"/>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="(tei:origDate != '')">
                            <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]         and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))        or following-sibling::tei:physDesc/descendant::tei:supportDesc        or tei:origPlace or following-sibling::tei:history/tei:origin//tei:origPlace">
                                <xsl:value-of select="$Trennzeichen"/>
                            </xsl:if>
                            <xsl:apply-templates select="tei:origDate" mode="Schlagzeile"/>
                        </xsl:when>
                        <xsl:when test="(following-sibling::tei:history/tei:origin//tei:origDate != '')">
                            <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]         and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))        or following-sibling::tei:physDesc/descendant::tei:supportDesc        or tei:origPlace or following-sibling::tei:history/tei:origin//tei:origPlace">
                                <xsl:value-of select="$Trennzeichen"/>
                            </xsl:if>
                            <xsl:apply-templates select="following-sibling::tei:history/tei:origin//tei:origDate" mode="Schlagzeile"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </p>
        <xsl:for-each select="tei:note[@type != 'caption']">
            <p>
                <xsl:attribute name="class">schlagzeile</xsl:attribute>
                <xsl:value-of select="."/>
            </p>
        </xsl:for-each>
    </xsl:template>
    <xsl:template match="tei:head[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile-illum">
        <p>
            <xsl:attribute name="class">schlagzeile</xsl:attribute>
            <xsl:choose>
                <xsl:when test="(tei:origPlace != '')">
                    <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]       and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))">
                        <xsl:value-of select="$Trennzeichen"/>
                    </xsl:if>
                    <xsl:apply-templates select="tei:origPlace" mode="Schlagzeile"/>
                </xsl:when>
                <xsl:when test="(following-sibling::tei:history/tei:origin//tei:origPlace != '')">
                    <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]       and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))      or following-sibling::tei:physDesc/descendant::tei:supportDesc">
                        <xsl:value-of select="$Trennzeichen"/>
                    </xsl:if>
                    <xsl:apply-templates select="following-sibling::tei:history/tei:origin//tei:origPlace" mode="Schlagzeile"/>
                </xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="(tei:origDate != '')">
                    <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]       and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))      or following-sibling::tei:physDesc/descendant::tei:supportDesc      or tei:origPlace or following-sibling::tei:history/tei:origin//tei:origPlace">
                        <xsl:value-of select="$Trennzeichen"/>
                    </xsl:if>
                    <xsl:apply-templates select="tei:origDate" mode="Schlagzeile"/>
                </xsl:when>
                <xsl:when test="(following-sibling::tei:history/tei:origin//tei:origDate != '')">
                    <xsl:if test="preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]       and not(contains(preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')][1]/tei:idno)))      or following-sibling::tei:physDesc/descendant::tei:supportDesc      or tei:origPlace or following-sibling::tei:history/tei:origin//tei:origPlace">
                        <xsl:value-of select="$Trennzeichen"/>
                    </xsl:if>
                    <xsl:apply-templates select="following-sibling::tei:history/tei:origin//tei:origDate" mode="Schlagzeile"/>
                </xsl:when>
            </xsl:choose>
        </p>
    </xsl:template>
    <xsl:template match="tei:hi[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:seg[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:choose>
            <xsl:when test="@rend">
                <span>
                    <xsl:call-template name="attr-rend-verarbeiten">
                        <xsl:with-param name="value" select="@rend"/>
                    </xsl:call-template>
                    <xsl:apply-templates>
                        <xsl:with-param name="sprache" select="$lang"/>
                    </xsl:apply-templates>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates>
                    <xsl:with-param name="sprache" select="$lang"/>
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="following-sibling::node()[1][self::tei:hi or self::tei:seg]">
            <xsl:text> </xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:history[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="tei:p">
                <xsl:apply-templates select="tei:p"/>
            </xsl:when>
            <xsl:when test="not(normalize-space(.) = '')">
                <p>
                    <xsl:attribute name="class">history</xsl:attribute>
                    <xsl:if test="not(contains(.,'Herkunft: '))">
                        <xsl:text>Herkunft: </xsl:text>
                    </xsl:if>
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:idno[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Signatur">
        <p>
            <xsl:attribute name="class">shelfmark</xsl:attribute>
            <xsl:if test="$media != 'print-offline' ">
                <a>
                    <xsl:attribute name="name" select="ancestor::tei:msDesc/@xml:id"/>
                </a>
            </xsl:if>
            <xsl:if test="preceding-sibling::tei:settlement and not(preceding-sibling::tei:settlement = $ignoreInSettlement)">
                <xsl:value-of select="preceding-sibling::tei:settlement"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="preceding-sibling::tei:institution and not(preceding-sibling::tei:institution = $ignoreInInstitution)">
                <xsl:value-of select="preceding-sibling::tei:institution"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="preceding-sibling::tei:repository and not(preceding-sibling::tei:repository = $ignoreInRepository)">
                <xsl:value-of select="preceding-sibling::tei:repository"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="preceding-sibling::tei:collection and not(contains(preceding-sibling::tei:collection, $ignoreInCollection))">
                <xsl:value-of select="preceding-sibling::tei:collection"/>
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    <xsl:template match="tei:idno[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile">
        <xsl:choose>
            <xsl:when test="ancestor::tei:msDesc/@xml:id and ($media != 'print-offline')">
                <a name="{ancestor::tei:msDesc/@xml:id}"/>
            </xsl:when>
            <xsl:when test="ancestor::tei:TEI/@xml:id and ($media != 'print-offline')">
                <a name="{ancestor::tei:TEI/@xml:id}"/>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="preceding-sibling::tei:settlement and not(preceding-sibling::tei:settlement = $ignoreInSettlement)   or preceding-sibling::tei:institution and not(preceding-sibling::tei:institution = $ignoreInInstitution)   or preceding-sibling::tei:repository and not(preceding-sibling::tei:repository = $ignoreInRepository)   or preceding-sibling::tei:collection and not(preceding-sibling::tei:collection = $ignoreInCollection)">
            <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:idno[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:settlement[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="ancestor::tei:msPart and not(text() = ancestor::tei:msDesc/tei:msIdentifier[tei:settlement and tei:idno]/text())">
                <xsl:apply-templates/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:incipit[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default condensed">
        <xsl:if test="contains(@rend, 'dottedBegin')">
            <xsl:text>… </xsl:text>
        </xsl:if>
        <span>
            <xsl:attribute name="class">
                <xsl:text>incipit</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates mode="#current"/>
        </span>
        <xsl:choose>
            <xsl:when test="tei:gap[not(following-sibling::node())]">
                <xsl:text> </xsl:text>
            </xsl:when>
            <xsl:when test="(@type = 'recipe') or (@type = 'sermon')">
                <xsl:text> … </xsl:text>
            </xsl:when>
            <xsl:when test="contains(@rend, 'dottedEnd')"><!--  or following-sibling::tei:incipit -->
                <xsl:text> … </xsl:text>
            </xsl:when>
            <xsl:when test="following-sibling::tei:explicit or following-sibling::tei:finalRubric">
                <xsl:text> … — </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="writePunctuation"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:item[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="ancestor::tei:list[@type = 'bibliography']">
                <li>
                    <xsl:apply-templates/>
                </li>
            </xsl:when>
            <xsl:when test="(($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum')) and ancestor::tei:decoDesc">
                <p>
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
                <xsl:call-template name="writePunctuation"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:l[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:apply-templates/>
        <xsl:if test="following-sibling::tei:l">
            <xsl:text> | </xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:layout" mode="#all">
        <xsl:text> </xsl:text>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:lb">
        <xsl:choose>
            <xsl:when test="parent::tei:rubric or parent::tei:incipit or parent::tei:quote or parent::tei:explicit or parent::tei:colophon or parent::tei:finalRubric">
                <xsl:text> | </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <br/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:list[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="($rend!='normal') and (ancestor::tei:physDesc or ancestor::tei:msItem)">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:otherwise>
                <ul>
                    <xsl:apply-templates/>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:listBibl[tei:bibl[normalize-space(.)]]">
        <xsl:choose>
            <xsl:when test="parent::tei:additional and contains(ancestor::tei:TEI/descendant-or-self::tei:titleStmt/tei:title, 'Signaturdokument')">
                <xsl:choose>
                    <xsl:when test="tei:head">
                        <div class="head">
                            <xsl:value-of select="tei:head"/>
                        </div>
                        <ul>
                            <xsl:for-each select="tei:bibl">
                                <li>
                                    <xsl:apply-templates>
                                        <xsl:with-param name="sprache" select="$lang"/>
                                    </xsl:apply-templates>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </xsl:when>
                    <xsl:when test="ancestor::tei:additional and not(tei:head)">
                        <div class="head">
                            <xsl:choose>
                                <xsl:when test="$lang = 'en' ">Bibliography</xsl:when>
                                <xsl:when test="$lang = 'fr' ">Bibliographie</xsl:when>
                                <xsl:when test="$lang = 'it' ">Bibliografia</xsl:when>
                                <xsl:otherwise>Bibliographie</xsl:otherwise>
                            </xsl:choose>
                        </div>
                        <ul>
                            <xsl:for-each select="tei:bibl">
                                <li>
                                    <xsl:apply-templates>
                                        <xsl:with-param name="sprache" select="$lang"/>
                                    </xsl:apply-templates>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="parent::tei:additional">
                <xsl:apply-templates/>
                <xsl:if test="not($literaturDB='')">
                    <xsl:call-template name="literaturDB">
                        <xsl:with-param name="xmlid" select="translate(substring-before(substring-after(ancestor-or-self::tei:TEI/@xml:id,concat($repository_short,$collection)),$Katalogisat-Postfix),'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜ','abcdefghijklmnopqrstuvwxyzäöü')"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
			<!-- vorher: when test="parent::tei:msItem" -->
                <xsl:if test="tei:head">
                    <span>
                        <xsl:attribute name="class">listBiblHead</xsl:attribute>
                        <xsl:value-of select="tei:head"/>
                        <xsl:if test="not(contains(tei:head,':'))">
                            <xsl:text>: </xsl:text>
                        </xsl:if>
                    </span>
                </xsl:if>
                <xsl:apply-templates select="*[not(self::tei:head)]"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:locus[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:param name="index"/>
        <xsl:param name="context"/>
        <xsl:choose>
            <xsl:when test="parent::tei:rubric or parent::tei:incipit or parent::tei:quote or parent::tei:explicit or parent::tei:colophon or parent::tei:finalRubric or ancestor::tei:index">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:call-template name="constructLocus">
                        <xsl:with-param name="index" select="$index"/>
                        <xsl:with-param name="context" select="$context"/>
                    </xsl:call-template>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="constructLocus">
                    <xsl:with-param name="index" select="$index"/>
                    <xsl:with-param name="context" select="$context"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="(parent::tei:decoNote or parent::tei:locusGrp or parent::tei:musicNotation) and following-sibling::tei:locus and not($index = 'yes')">
            <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:if test="not($index = 'yes')">
            <xsl:call-template name="writeWhitespace"/>
        </xsl:if>
    </xsl:template>
    <xsl:template name="constructLocus">
        <xsl:param name="index"/>
        <xsl:param name="context"/>
        <xsl:if test="not($index='yes') and (parent::tei:msItem/parent::tei:msItem or (parent::tei:locusGrp/parent::tei:msItem/parent::tei:msItem and not(preceding-sibling::tei:locus)) or parent::tei:item/ancestor::tei:msItem or parent::tei:explicit)    and not(ancestor::tei:index)    and not($index='yes')    and not(contains(., '('))   and not(following-sibling::tei:note[. = 'leer.'])">
            <xsl:text>(</xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="($index='yes') and parent::tei:locusGrp and preceding-sibling::tei:locus"/>
            <xsl:otherwise>
                <xsl:if test="(parent::tei:msItem/parent::tei:msItem or parent::tei:item/ancestor::tei:msItem)         and not(ancestor::tei:index)         and not($index='yes')         and not(contains(., '('))         and following-sibling::tei:note[. = 'leer.']">
                    <xsl:text> — </xsl:text>
                </xsl:if>
                <xsl:if test="not(parent::tei:ref[@type = 'altMs'])">
                    <xsl:choose>
                        <xsl:when test="$media='print-offline'">
                            <xsl:value-of select="."/>
                        </xsl:when>
                        <xsl:when test="$index = 'yes' and ($context = 'colophon') and @to">
                            <xsl:value-of select="@to"/>
                        </xsl:when>
                        <xsl:when test="$index = 'yes' and @from">
                            <xsl:value-of select="@from"/>
                        </xsl:when>
                        <xsl:when test="$index = 'yes'">
                            <xsl:value-of select="."/>
                        </xsl:when>
                        <xsl:when test="@from and @to and contains(.,'-')">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ')or contains(.,'f. ') or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(substring-before(.,'-'),'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>-</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'-')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-before(.,'-')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>-</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'-')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="@from and @to and contains(.,'—')">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ')or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(substring-before(.,'—'),'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>—</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'—')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-before(.,'—')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>—</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'—')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="@from and @to and contains(.,'–')">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ')or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(substring-before(.,'–'),'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>–</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'–')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-before(.,'–')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>–</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'–')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="@from and @to and contains(.,'/')">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ')or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(substring-before(.,'/'),'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>/</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'/')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-before(.,'/')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>/</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@to"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'/')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="@from">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ') or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@from"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="."/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="@target and not(contains(@target,' '))">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ') or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@target"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="@target"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="."/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="contains(.,'-')">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ')or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-before(.,'-')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(substring-before(.,'-'),'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>-</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-after(.,'-')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'-')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-before(.,'-')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-before(.,'-')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>-</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-after(.,'-')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'-')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:when test="contains(.,'/')">
                            <xsl:choose>
                                <xsl:when test="contains(.,'Foll. ') or contains(.,'Fol. ') or contains(.,'fol. ') or contains(.,'ff. ') or contains(.,'f. ')or                            contains(.,'P. ') or contains(.,'p. ') or contains(.,'Pp. ') or contains(.,'pp. ') or                            contains(.,'S. ') or                            contains(.,'c. ') or contains(.,'cc. ')">
                                    <xsl:value-of select="concat(substring-before(.,'. '),'. ')"/>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-before(.,'/')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(substring-before(.,'/'),'. ')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>/</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-after(.,'/')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'/')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-before(.,'/')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-before(.,'/')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>/</xsl:text>
                                    <xsl:call-template name="locus-verlinken">
                                        <xsl:with-param name="attribute">
                                            <xsl:value-of select="substring-after(.,'/')"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="content">
                                            <xsl:value-of select="substring-after(.,'/')"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="locus-verlinken">
                                <xsl:with-param name="content">
                                    <xsl:value-of select="."/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="parent::tei:ref[@type = 'altMs']">
                    <xsl:value-of select="."/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not($index='yes') and (parent::tei:msItem/parent::tei:msItem or (parent::tei:locusGrp/parent::tei:msItem/parent::tei:msItem and not(following-sibling::tei:locus)) or parent::tei:item/ancestor::tei:msItem or parent::tei:explicit)    and not(ancestor::tei:index)    and not($index='yes')    and not(contains(., '('))   and not(following-sibling::tei:note[. = 'leer.'])">
            <xsl:text>) </xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:material[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile">
<!--	<xsl:if test="ancestor::tei:physDesc/preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')] 
		and not(contains(ancestor::tei:physDesc/preceding-sibling::tei:msIdentifier/tei:idno,concat('olim ',ancestor::tei:physDesc/preceding-sibling::tei:msIdentifier/tei:altIdentifier[@type = 'former'][not(@rend='doNotShow')]/tei:idno)))">
		<xsl:value-of select="$Trennzeichen"/>
	</xsl:if>-->
        <xsl:if test="preceding-sibling::tei:material">
            <xsl:apply-templates select="preceding-sibling::tei:locus[position() = 1]"/>
            <xsl:call-template name="writeWhitespace"/>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="following-sibling::tei:material">
                <xsl:value-of select="."/>
                <xsl:text>, </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="."/>
<!--		    <xsl:value-of select="$Trennzeichen"/>-->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:measure[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="(@type = 'written')">
                <xsl:choose>
                    <xsl:when test="not(starts-with(.,'Schriftraum'))">
                        <xsl:text>Schriftraum: </xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="(@type = 'pageDimensions')"/>
            <xsl:when test="@unit and not(contains(.,'cm') or contains(.,'mm'))">
                <xsl:apply-templates/>
                <xsl:value-of select="concat(' ',@unit)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="($mode='test') and ((@type = 'pageDimensions') or (@type = 'written')) and not(@unit) and not(contains(.,'cm')) and not(contains(.,'mm'))">
            <xsl:text>KEIN MAßSTAB VORHANDEN!</xsl:text>
        </xsl:if>
        <xsl:call-template name="writePunctuation"/>
    </xsl:template>
    <xsl:template match="tei:msDesc">
        <xsl:param name="xmlid">
            <xsl:value-of select="replace(replace(replace(replace(replace(replace(replace(translate(translate(lower-case(tei:msIdentifier/tei:idno),'.',''),' ','-'),'fol','2f'),'4to','4f'),'8vo','8f'),'12mo','12f'),'α','alpha'),'β','beta'),'—','--')"/>
        </xsl:param>
        <div class="msIdentifier">
            <xsl:choose>
                <xsl:when test="contains(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, 'Signaturdokument')">
                    <xsl:value-of select="ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                </xsl:when>
                <xsl:when test="contains(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, ') — ')">
                    <xsl:value-of select="concat(substring-before(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, ') — '), ')')"/>
                </xsl:when>
                <xsl:when test="contains(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, concat('; ', tei:additional//tei:recordHist/tei:source))">
                    <xsl:value-of select="concat(substring-before(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, concat('; ', tei:additional//tei:recordHist/tei:source)), ')')"/>
                </xsl:when>
                <xsl:when test="contains(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, concat(' (', tei:additional//tei:recordHist/tei:source))">
                    <xsl:value-of select="substring-before(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, concat(' (', tei:additional//tei:recordHist/tei:source))"/>
                </xsl:when>
                <xsl:when test="contains(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, tei:additional//tei:recordHist/tei:source)">
                    <xsl:value-of select="substring-before(ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title, tei:additional//tei:recordHist/tei:source)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@status = 'unfinished' ">
                    <xsl:text> (Vorläufige Beschreibung)</xsl:text>
                </xsl:when>
            </xsl:choose>
        </div>
        <div class="source">
            <xsl:apply-templates select="descendant::tei:source/tei:bibl"/>
            <xsl:if test="ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:funder">
                <br/>
                <xsl:for-each select="ancestor::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:funder">
                    <xsl:if test="preceding-sibling::tei:funder">
                        <xsl:text>, </xsl:text>
                    </xsl:if>
                    <xsl:apply-templates/>
                </xsl:for-each>
            </xsl:if>
        </div>
        <xsl:choose>
            <xsl:when test="tei:p">
                <xsl:apply-templates select="tei:p[not(. = tei:bibl)]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="writeMsHeading"/>
                <xsl:choose>
                    <xsl:when test="($catalogueType = 'illum') or (@type = 'illum')">
                        <xsl:apply-templates select="tei:head[1]" mode="Schlagzeile-illum"/>
                        <xsl:if test="exists(//tei:ref[@type = 'graphic'])">
                            <xsl:call-template name="writeGraphicList"/>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="tei:head[1]" mode="Schlagzeile"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:call-template name="Hauptverteiler"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:msItem">
        <xsl:choose>
            <xsl:when test="parent::tei:msContents and not(ancestor::tei:msPart[@rend = 'condensed']) and not(ancestor::tei:msFrag) and not(($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum'))">
                <p>
                    <xsl:attribute name="class">msitem</xsl:attribute>
                    <xsl:apply-templates/>
                    <xsl:call-template name="writePunctuation"/>
                </p>
            </xsl:when>
            <xsl:when test="(parent::tei:msItem[parent::tei:msContents]     and descendant::tei:msItem     and (number(substring-before(tei:locus[1]/@from, 'r') or substring-before(tei:locus[1]/@from, 'v')) gt number(substring-before(parent::*/tei:locus[1]/@from, 'r') or substring-before(parent::*/tei:locus[1]/@from, 'v'))))    or (contains(@rend, 'break'))    and not(($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum'))">
                <br/>
                <xsl:apply-templates/>
                <xsl:call-template name="writePunctuation"/>
            </xsl:when>
            <xsl:when test="parent::tei:msItem[parent::tei:msContents]     and descendant::tei:msItem[tei:note[.='leer.']]     and (number(substring-before(tei:locus[1]/@from, 'r') or substring-before(tei:locus[1]/@from, 'v')) le number(substring-before(parent::*/tei:locus[1]/@from, 'r') or substring-before(parent::*/tei:locus[1]/@from, 'v')))    and not(($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum'))">
                <xsl:text> – </xsl:text>
                <xsl:apply-templates mode="#current"/>
                <xsl:call-template name="writePunctuation"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates mode="#current"/>
                <xsl:call-template name="writePunctuation"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="contains(@rend,'after:content')">
                <xsl:value-of select="concat(' ',substring-before(substring-after(@rend,'after:content('),')'))"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:msName[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:if test="preceding-sibling::tei:msName">
            <xsl:value-of select="$Trennzeichen"/>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:msPart[@type = 'binding']">
        <xsl:choose>
            <xsl:when test="tei:p">
                <xsl:apply-templates select="tei:p"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="tei:msIdentifier | tei:altIdentifier" mode="msPart"/>
                <xsl:if test="($showMsPartTitles = 'yes')">
                    <xsl:call-template name="writeMsHeading"/>
                </xsl:if>
                <xsl:apply-templates select="tei:head" mode="Schlagzeile"/>
                <xsl:call-template name="Hauptverteiler"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:msPart[not(@rend = 'condensed')][not(@type = 'binding')][not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:apply-templates select="tei:msIdentifier | tei:altIdentifier" mode="msPart"/>
        <xsl:if test="($showMsPartTitles = 'yes')">
            <xsl:call-template name="writeMsHeading"/>
        </xsl:if>
        <xsl:apply-templates select="tei:head" mode="Schlagzeile"/>
        <xsl:call-template name="Hauptverteiler"/>
    </xsl:template>
    <xsl:template match="tei:name" mode="meta">
        <xsl:if test="preceding-sibling::*[1][self::tei:name]">, </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:name[@type='project'][not(@subtype)]">
        <a href="?db=mss&amp;list=project&amp;id={.}">
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    <xsl:template match="tei:note[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:if test="@rend='supplied'">
            <xsl:text>[</xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="parent::tei:rubric or parent::tei:incipit or parent::tei:quote or parent::tei:explicit or parent::tei:colophon or parent::tei:finalRubric">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:text> (</xsl:text>
                    <xsl:apply-templates/>
                    <xsl:text>)</xsl:text>
                </span>
            </xsl:when>
            <xsl:when test="parent::tei:title">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="@rend='supplied'">
                <xsl:text>] </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="writePunctuation"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:origin[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:acquisition[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:if test="(preceding-sibling::tei:origin[not(normalize-space(.) = '')] or preceding-sibling::tei:provenance[not(. = '')])    and not(normalize-space(.) = '')">
            <xsl:value-of select="$Trennzeichen"/>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:provenance[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="(preceding-sibling::tei:origin[not(normalize-space(.) = '')] and not(preceding-sibling::tei:provenance[not(. = '')]))    and not(normalize-space(.) = descendant::tei:index)    and not(normalize-space(.) = '')">
                <xsl:value-of select="$Trennzeichen"/>
            </xsl:when>
            <xsl:when test="preceding-sibling::tei:provenance[not(. = '')]">
                <xsl:text> </xsl:text>
            </xsl:when>
        </xsl:choose>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:origDate[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile">
	<!-- Entstehungszeit -->
        <xsl:if test="preceding-sibling::tei:origDate">
            <xsl:text> / </xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="parent::tei:head">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="ancestor::tei:origin">
                <xsl:choose>
                    <xsl:when test="not(ancestor::tei:msPart)">
                        <xsl:if test="not(preceding-sibling::tei:origDate)">
                            <xsl:value-of select="$Trennzeichen"/>
                        </xsl:if>
                        <xsl:apply-templates/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="not(preceding::tei:msPart) and not(preceding-sibling::tei:origDate)">
                            <xsl:value-of select="$Trennzeichen"/>
                        </xsl:if>
                        <xsl:value-of select="ancestor::tei:msPart/tei:altIdentifier/tei:idno"/>
                        <xsl:text>: </xsl:text>
                        <xsl:apply-templates/>
                        <xsl:if test="following::tei:msPart/descendant::tei:origDate">
                            <xsl:text> / </xsl:text>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:origPlace" mode="condensed">
        <xsl:apply-templates mode="condensed"/>
        <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
        <xsl:call-template name="writePunctuation"/>
        <xsl:text> </xsl:text>
    </xsl:template>
    <xsl:template match="tei:origPlace[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="Schlagzeile">
	<!-- Entstehungsort -->
        <xsl:choose>
            <!--
            <xsl:when test="preceding-sibling::tei:origPlace and parent::node()/tei:origPlace[@cert='medium']">
                <xsl:text> oder </xsl:text>
            </xsl:when>
            -->
            <xsl:when test="preceding-sibling::tei:origPlace">
                <xsl:text> / </xsl:text>
            </xsl:when>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="parent::tei:head">
                <xsl:value-of select="."/>
                <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
            </xsl:when>
            <xsl:when test="ancestor::tei:origin">
                <xsl:choose>
                    <xsl:when test="not(ancestor::tei:msPart)">
                        <xsl:if test="not(preceding-sibling::tei:origPlace)">
                            <xsl:value-of select="$Trennzeichen"/>
                        </xsl:if>
                        <xsl:value-of select="."/>
                        <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="not(preceding::tei:msPart) and not(preceding-sibling::tei:origPlace)">
                            <xsl:value-of select="$Trennzeichen"/>
                        </xsl:if>
                        <xsl:value-of select="ancestor::tei:msPart/tei:altIdentifier/tei:idno"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="."/>
                        <xsl:if test="exists(@cert) and @cert != 'high' "> (?)</xsl:if>
                        <xsl:if test="following::tei:msPart/descendant::tei:origPlace">
                            <xsl:text> / </xsl:text>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:p[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:choose>
            <xsl:when test="parent::tei:msDesc or parent::tei:msPart or parent::tei:msContents or parent::tei:physDesc or parent::tei:history">
                <p>
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
            <xsl:when test="(ancestor::tei:msFrag or ancestor::tei:msPart[@rend='condensed'])     and ((normalize-space(.) = 'Perg.')     or (normalize-space(.) = 'Papier')     or (normalize-space(.) = 'Pap.')     or (normalize-space(.) = 'Pergament')    or (normalize-space(.) = 'Pergament und Papier')    or (normalize-space(.) = 'Papier und Pergament'))    or (normalize-space(.) = descendant::tei:material)">
                <xsl:value-of select="."/>
                <xsl:call-template name="writePunctuation"/>
                <xsl:text> </xsl:text>
            </xsl:when>
            <xsl:when test="(normalize-space(.) = 'Perg.')     or (normalize-space(.) = 'Papier')     or (normalize-space(.) = 'Pap.')     or (normalize-space(.) = 'Pergament')    or (normalize-space(.) = 'Pergament und Papier')    or (normalize-space(.) = 'Papier und Pergament')    or (normalize-space(.) = descendant::tei:material)"/>
            <xsl:when test="@rend='break'">
                <p>
                    <xsl:if test="@xml:id and ($media != 'print-offline')">
                        <a name="{@xml:id}"/>
                    </xsl:if>
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="@xml:id and preceding-sibling::tei:p">
                    <br/>
                </xsl:if>
                <xsl:if test="@xml:id and ($media != 'print-offline')">
                    <a name="{@xml:id}"/>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="(tei:origPlace or tei:origDate) and not(text())"/>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:call-template name="writeWhitespace"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:physDesc">
        <p>
            <xsl:choose>
                <xsl:when test="($catalogueType = 'illum') or (ancestor::tei:msDesc/@type = 'illum')">
                    <xsl:attribute name="class">physDesc_illum</xsl:attribute>
                    <xsl:apply-templates select="*[not(self::tei:accMat) and not(self::tei:additions) and not(self::tei:bindingDesc) and not(self::tei:decoDesc)]"/>
                    <xsl:apply-templates select="tei:additions"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">physDesc</xsl:attribute>
                    <xsl:apply-templates select="*[not(self::tei:accMat) and not(self::tei:additions) and not(self::tei:bindingDesc) and not(self::tei:decoDesc)]"/>
                    <xsl:apply-templates select="tei:additions"/>
                    <xsl:apply-templates select="tei:decoDesc"/>
                </xsl:otherwise>
            </xsl:choose>
        </p>
        <xsl:apply-templates select="tei:bindingDesc"/>
        <xsl:apply-templates select="tei:accMat"/>
    </xsl:template>
    <xsl:template match="tei:quote[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:signatures[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:if test="@type = 'rubric' ">
            <span>
                <xsl:attribute name="class">smaller</xsl:attribute>
                <xsl:text>›</xsl:text>
            </span>
        </xsl:if>
        <xsl:if test="contains(@rend, 'dottedBegin')">
            <xsl:text>… </xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="contains(@rend,'before:content')">
                <xsl:value-of select="substring-before(substring-after(@rend,'before:content('),')')"/>
            </xsl:when>
        </xsl:choose>
        <span>
            <xsl:attribute name="class">quote</xsl:attribute>
            <xsl:apply-templates mode="#current"/>
        </span>
        <xsl:choose>
            <xsl:when test="contains(@rend,'after:content')">
                <xsl:value-of select="substring-before(substring-after(@rend,'after:content('),')')"/>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="@rend = 'dottedEnd' ">
            <xsl:text> …</xsl:text>
        </xsl:if>
        <xsl:if test="@type = 'rubric'">
            <span>
                <xsl:attribute name="class">smaller</xsl:attribute>
                <xsl:text>‹</xsl:text>
            </span>
        </xsl:if>
        <xsl:choose>
<!--
		<xsl:when test="(@type = 'rubric') and following-sibling::node()[1][self::tei:quote[@type = 'incipit']]">
			<xsl:text> … </xsl:text>
		</xsl:when>
-->
            <xsl:when test="(@type = 'incipit') and following-sibling::node()[1][self::tei:quote[@type = 'explicit']]">
                <xsl:text> … — … </xsl:text>
            </xsl:when>
            <xsl:when test="tei:gap[not(following-sibling::text())]">
                <xsl:call-template name="writeWhitespace"/>
            </xsl:when>
            <xsl:when test="not(following-sibling::node()[1]=following-sibling::text()[1])">
                <xsl:call-template name="writeWhitespace"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:ref[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:ptr" mode="#default condensed Einzeldatei meta msPart Schlagzeile Schlagzeile-illum Signatur">
        <xsl:choose>
            <!--
		<xsl:when test="$media = 'print-offline' ">
			<xsl:apply-templates/>
		</xsl:when>
		-->
            <xsl:when test="@target and (@type = 'entity')">
                <xsl:choose>
                    <xsl:when test=" $media != 'print-offline' ">
                        <a href="{unparsed-entity-uri(@target)}">
                            <xsl:if test="@n">
                                <xsl:value-of select="@n"/>
                            </xsl:if>
                            <xsl:apply-templates/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="@n">
                            <xsl:value-of select="@n"/>
                        </xsl:if>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@target">
                <xsl:choose>
                    <xsl:when test=" $media != 'print-offline' ">
                        <a href="{@target}">
                            <xsl:apply-templates/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="not(@target) and starts-with(., 'http://')">
                <xsl:choose>
                    <xsl:when test="$media != 'print-offline' ">
                        <a>
                            <xsl:attribute name="href">
                                <xsl:choose>
                                    <xsl:when test="contains(., ' ')">
                                        <xsl:value-of select="substring-before(., ' ')"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="."/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                            <xsl:apply-templates/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'urn') and ($media != 'print-offline')">
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$urn-resolver"/>
                        <xsl:value-of select="."/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type = 'biblical') and @cRef">
                <xsl:if test="not(normalize-space(.) = translate(@cRef, '_.', '  '))">
                    <xsl:apply-templates/>
                </xsl:if>
                <xsl:if test="not(self::tei:ptr) and normalize-space(.) = normalize-space(parent::node())">
                    <xsl:call-template name="writePunctuation"/>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="$media != 'print-offline' ">
                        <a>
                            <xsl:attribute name="href">
                                <xsl:value-of select="$cRef-biblical-start"/>
                                <xsl:choose>
                                    <xsl:when test="starts-with(@cRef, 'IV_')">
                                        <xsl:value-of select="replace(translate(translate(translate(@cRef,' ','+'),',',':'),'_',' '), 'IV', '4')"/>
                                    </xsl:when>
                                    <xsl:when test="starts-with(@cRef, 'III_')">
                                        <xsl:value-of select="replace(translate(translate(translate(@cRef,' ','+'),',',':'),'_',' '), 'III', '3')"/>
                                    </xsl:when>
                                    <xsl:when test="starts-with(@cRef, 'II_')">
                                        <xsl:value-of select="replace(translate(translate(translate(@cRef,' ','+'),',',':'),'_',' '), 'II', '2')"/>
                                    </xsl:when>
                                    <xsl:when test="starts-with(@cRef, 'I_')">
                                        <xsl:value-of select="replace(translate(translate(translate(@cRef,' ','+'),',',':'),'_',' '), 'I', '1')"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="translate(translate(translate(@cRef,' ','+'),',',':'),'_',' ')"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <xsl:value-of select="$cRef-biblical-end"/>
                            </xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="(ancestor::tei:rubric or ancestor::tei:incipit or ancestor::tei:quote or ancestor::tei:explicit or ancestor::tei:colophon or ancestor::tei:finalRubric or ancestor::tei:index or ancestor::tei:title) and not(parent::note)">
                                    <span>
                                        <xsl:attribute name="class">normal</xsl:attribute>
                                        <xsl:call-template name="constructCRef"/>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="constructCRef"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="(ancestor::tei:rubric or ancestor::tei:incipit or ancestor::tei:quote or ancestor::tei:explicit or ancestor::tei:colophon or ancestor::tei:finalRubric or ancestor::tei:index or ancestor::tei:title) and not(parent::note)">
                                <span>
                                    <xsl:attribute name="class">normal</xsl:attribute>
                                    <xsl:call-template name="constructCRef"/>
                                </span>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="constructCRef"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'cao') and @cRef">
                <xsl:apply-templates/>
                <xsl:text> [</xsl:text>
                <a href="#cao">CAO</a>
                <xsl:text> </xsl:text>
                <xsl:value-of select="@cRef"/>
                <xsl:text>]</xsl:text>
                <xsl:call-template name="writePunctuation"/>
            </xsl:when>
            <xsl:when test="(@type = 'classical') or (@type = 'medieval') ">
                <xsl:apply-templates/>
                <xsl:choose>
                    <xsl:when test="(ancestor::tei:rubric or ancestor::tei:incipit or ancestor::tei:quote or ancestor::tei:explicit or ancestor::tei:colophon or ancestor::tei:finalRubric or ancestor::tei:index) and not(parent::note)">
                        <span>
                            <xsl:attribute name="class">normal</xsl:attribute>
                            <xsl:call-template name="constructCRef"/>
                        </span>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="constructCRef"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'ebdb') and @cRef">
                <xsl:choose>
                    <xsl:when test="$media != 'print-offline' ">
                        <xsl:if test="self::tei:ptr">
                            <a href="#EBDB">EBDB</a>
                            <xsl:text> </xsl:text>
                        </xsl:if>
                        <a>
                            <xsl:attribute name="href">
                                <xsl:choose>
                                    <xsl:when test="starts-with(@cRef, 's') or          starts-with(@cRef, 'r') or          starts-with(@cRef, 'p')">
                                        <xsl:value-of select="concat($ebdb, 'wz=', @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="starts-with(@cRef, 'w')">
                                        <xsl:value-of select="concat($ebdb, 'ws=', @cRef)"/>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="self::tei:ptr">
                                    <xsl:value-of select="@cRef"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:apply-templates/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="self::tei:ptr">
                                <xsl:value-of select="concat('EBDB ', @cRef)"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@cRef and (    @type = 'cantus' or    @type = 'gbv' or @type = 'gw' or    @type = 'opac' or    @type = 'Piccard-Online' or    @type = 'vd17' or    @type = 'wilc' or @type = 'wzis' or @type = 'wzma'    )">
                <xsl:choose>
                    <xsl:when test="$media != 'print-offline' ">
                        <a>
                            <xsl:attribute name="href">
                                <xsl:choose>
                                    <xsl:when test="@type = 'cantus'">
                                        <xsl:value-of select="concat($cantus, @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'gbv'">
                                        <xsl:value-of select="concat($gbv, @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'gw'">
                                        <xsl:value-of select="concat($cRef-gw-start, @cRef, $cRef-gw-end)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'opac'">
                                        <xsl:value-of select="concat($opac, @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'Piccard-Online'">
                                        <xsl:value-of select="concat($Piccard-Online, @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'vd17'">
                                        <xsl:value-of select="concat($vd17, @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'wilc'">
                                        <xsl:value-of select="concat($wilc, translate(substring-after(@cRef, 'WM_'), '_', '+'), '&amp;max=50')"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'wzis'">
                                        <xsl:value-of select="concat($wzis, @cRef)"/>
                                    </xsl:when>
                                    <xsl:when test="@type = 'wzma'">
                                        <xsl:value-of select="concat($wzma, @cRef)"/>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="self::tei:ptr">
                                    <xsl:value-of select="@cRef"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:apply-templates/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="self::tei:ptr">
                                <xsl:value-of select="@cRef"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'vd16') and @cRef">
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="concat($vd16, @cRef)"/>
                    </xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="self::tei:ptr">
                            <xsl:value-of select="translate(@cRef, '+', ' ')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates/>
                        </xsl:otherwise>
                    </xsl:choose>
                </a>
            </xsl:when>
            <xsl:when test="(@type='mss') and @cRef[starts-with(., 'mss_')][contains(substring-after(., 'mss_'), 'tei-msDesc_')]">
                <a href="?db=mss&amp;list=ms&amp;id={substring-before(substring-after(@cRef, 'mss_'), '_')}&amp;catalog={substring-after(@cRef, 'tei-msDesc_')}">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type='mss') and @cRef[starts-with(., 'mss_')]">
                <a href="?db=mss&amp;list=ms&amp;id={substring-after(@cRef, 'mss_')}">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type='mss') and @cRef[contains(., 'tei-msDesc_')]">
                <a href="?db=mss&amp;list=ms&amp;id={substring-before(@cRef, '_')}&amp;catalog={substring-after(@cRef, 'tei-msDesc_')}">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type='mss') and @cRef[contains(., 'heinemann-')]">
                <a href="?db=mss&amp;list=ms&amp;id={substring-after(@cRef, 'heinemann-')}&amp;catalog=Heinemann">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type='mss') and @cRef">
                <a href="?db=mss&amp;list=ms&amp;id={@cRef}">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type='edoc') and @cRef">
                <a href="edoc/{@cRef}/start.htm" target="_blank">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type = 'ba') and @cRef">
                <a href="{$server}?db=mss&amp;list=ms&amp;id={@cRef}">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="(@type = 'edoc') and @cRef">
                <a href="edoc/{@cRef}/start.htm" target="_blank">
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="($listAbbreviatedTitles = 'yes') and parent::tei:bibl and    ((.=//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label) or    (@target=//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id))">
                <a>
                    <xsl:attribute name="href">
                        <xsl:text>#</xsl:text>
                        <xsl:value-of select="translate(//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item[tei:label=current()]/tei:label,' ()','_')"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:when test="($listAbbreviatedTitles = 'no') and parent::tei:bibl and    ((.=//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label) or      (@target=//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id))">
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$opac"/>
                        <xsl:choose>
                            <xsl:when test=".=//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/tei:label">
                                <xsl:value-of select="substring-after(//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item[tei:label=current()]/@xml:id,'opac_')"/>
                            </xsl:when>
                            <xsl:when test="@target=//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item/@xml:id">
                                <xsl:value-of select="substring-after(//tei:list[@type = 'bibliography'][not(preceding::tei:list[@type = 'bibliography'])]/tei:item[@xml:id=current()/@target]/@xml:id,'opac_')"/>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(tei:hi) and not(parent::tei:bibl)">
            <xsl:call-template name="writeWhitespace"/>
        </xsl:if>
    </xsl:template>
    <xsl:template name="constructCRef">
        <xsl:if test="ancestor::tei:rubric or ancestor::tei:incipit or ancestor::tei:quote or ancestor::tei:explicit or ancestor::tei:colophon or ancestor::tei:finalRubric or ancestor::tei:index or ancestor::tei:title">
            <xsl:text> [</xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="not(normalize-space(.) = translate(@cRef, '_', ' '))">
                <xsl:choose>
                    <xsl:when test="starts-with(@cRef, 'Lao')">
                        <xsl:value-of select="translate(translate(translate(translate(@cRef,'+',' '),':',','),'_',' '), 'Lao', 'Laod')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="translate(translate(translate(@cRef,'+',' '),':',','),'_',' ')"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="ancestor::tei:rubric or ancestor::tei:incipit or ancestor::tei:quote or ancestor::tei:explicit or ancestor::tei:colophon or ancestor::tei:finalRubric or ancestor::tei:index or ancestor::tei:title">
            <xsl:text>]</xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:resp" mode="meta">
        <xsl:apply-templates/>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:revisionDesc">
        <xsl:param name="sprache"/>
        <div>
            <span class="head">
                <xsl:choose>
                    <xsl:when test="$lang = 'en' ">Revisions: </xsl:when>
                    <xsl:when test="$lang = 'fr' ">Revisions: </xsl:when>
                    <xsl:when test="$lang = 'it' ">Revisions: </xsl:when>
                    <xsl:otherwise>Korrekturen, Ergänzungen: </xsl:otherwise>
                </xsl:choose>
            </span>
            <ul>
                <xsl:apply-templates select="tei:change">
                    <xsl:with-param name="sprache" select="$sprache"/>
                </xsl:apply-templates>
            </ul>
        </div>
    </xsl:template>
    <xsl:template match="tei:change">
        <xsl:param name="sprache"/>
        <li>
            <xsl:choose>
                <xsl:when test="starts-with(., 'Einen Eintrag in einer Ausstellung hinzugefügt: ')">
                    <xsl:text>Einen Eintrag in einer Ausstellung hinzugefügt: </xsl:text>
                    <a href="?db=mss&amp;list=exhibition&amp;id={substring-after(., 'Einen Eintrag in einer Ausstellung hinzugefügt: ')}">
                        <xsl:value-of select="substring-after(., 'Einen Eintrag in einer Ausstellung hinzugefügt: ')"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text> (</xsl:text>
            <xsl:value-of select="if (starts-with(@who, '#')) then substring(@who, 2) else substring(@who, 1)"/>
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@when"/>
            <xsl:text>)</xsl:text>
        </li>
    </xsl:template>
    <xsl:template match="tei:row[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="(@role='label')">
                <th>
				<!--xsl:attribute name="nowrap">nowrap</xsl:attribute-->
                    <xsl:apply-templates/>
                </th>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:apply-templates/>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:rs[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test=" (@role = 'author') ">
                <span>
                    <xsl:attribute name="class">author</xsl:attribute>
                    <xsl:apply-templates/>
                </span>
                <xsl:call-template name="writeWhitespace"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
                <xsl:call-template name="writeWhitespace"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:rubric[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]] | tei:finalRubric[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:choose>
            <xsl:when test="(@type = 'supplied')">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:if test="not(starts-with(.,'['))">[</xsl:if>
                    <xsl:apply-templates/>
                    <xsl:if test="not(contains(.,']'))">]</xsl:if>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <span>
                    <xsl:attribute name="class">smaller</xsl:attribute>
                    <xsl:text>›</xsl:text>
                </span>
                <xsl:choose>
                    <xsl:when test="contains(@rend,'before:content')">
                        <xsl:value-of select="substring-before(substring-after(@rend,'before:content('),')')"/>
                    </xsl:when>
                </xsl:choose>
                <span>
                    <xsl:attribute name="class">rubric</xsl:attribute>
                    <xsl:apply-templates/>
                </span>
                <xsl:choose>
                    <xsl:when test="contains(@rend,'after:content')">
                        <xsl:value-of select="substring-before(substring-after(@rend,'after:content('),')')"/>
                    </xsl:when>
                </xsl:choose>
                <xsl:if test="not(normalize-space(.) = normalize-space(tei:ref[1]))">
                    <span>
                        <xsl:attribute name="class">smaller</xsl:attribute>
                        <xsl:text>‹</xsl:text>
                    </span>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="contains(@rend, 'dottedEnd')">
                <xsl:text> … </xsl:text>
            </xsl:when>
            <xsl:when test="following-sibling::*[1][self::tei:finalRubric]">
                <xsl:text> … — … </xsl:text>
            </xsl:when>
            <xsl:when test="not(normalize-space(.) = normalize-space(tei:ref[1]))">
                <xsl:call-template name="writePunctuation"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:sic[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <xsl:apply-templates/>
        <xsl:if test="not(parent::tei:choice) and not(contains(.,'['))">
            <span>
                <xsl:attribute name="class">normal</xsl:attribute>
                <xsl:text> [!]</xsl:text>
            </span>
        </xsl:if>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:soCalled[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:text>"</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>"</xsl:text>
    </xsl:template>
    <xsl:template match="tei:summary[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="tei:p">
                <p>
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:supplied[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#all">
        <span>
            <xsl:attribute name="class">normal</xsl:attribute>
            <xsl:if test="not(starts-with(.,'['))">[</xsl:if>
            <xsl:apply-templates/>
            <xsl:if test="not(contains(.,']'))">]</xsl:if>
        </span>
        <xsl:if test="not(parent::tei:w)    and not(parent::tei:rubric)    and not(parent::tei:incipit)    and not(parent::tei:explicit)    and not(parent::tei:finalRubric)    and not(parent::tei:colophon)   and not(parent::tei:quote)">
            <xsl:call-template name="writeWhitespace"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:support">
        <xsl:choose>
            <xsl:when test="(normalize-space(.) = 'Pergament')                 or (normalize-space(.) = 'Perg.')                 or (normalize-space(.) = 'Kalbspergament')                 or (normalize-space(.) = 'Papier')                 or (normalize-space(.) = 'Pap.')                 or (normalize-space(.) = 'Pergament und Papier')                 or (normalize-space(.) = 'Papier und Pergament')                 or (normalize-space(.) = descendant::tei:material)"/>
            <xsl:when test="((normalize-space(tei:p[1]) = 'Pergament')                 or (normalize-space(tei:p[1]) = 'Perg.')                 or (normalize-space(tei:p[1]) = 'Kalbspergament')                 or (normalize-space(tei:p[1]) = 'Papier')                 or (normalize-space(tei:p[1]) = 'Pap.')                 or (normalize-space(tei:p[1]) = 'Pergament und Papier')                 or (normalize-space(tei:p[1]) = 'Papier und Pergament')                 or (normalize-space(tei:p[1]) = descendant::tei:material))                 and tei:p[2]">
                <xsl:apply-templates select="tei:p[position() gt 1]"/>
                <xsl:call-template name="writeWhitespace"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
                <xsl:call-template name="writeWhitespace"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:supportDesc">
        <xsl:choose>
            <xsl:when test="not(tei:p)">
                <xsl:apply-templates select="tei:support"/>
                <xsl:apply-templates select="tei:extent"/>
                <xsl:apply-templates select="tei:collation"/>
                <xsl:apply-templates select="tei:foliation"/>
                <xsl:apply-templates select="tei:condition"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:supportDesc" mode="Schlagzeile">
	<!-- Beschreibstoff -->
	<!-- später Datenprüfung durch das Schema -->
        <xsl:choose>
            <xsl:when test="tei:support/descendant::tei:material[normalize-space(.) != '']">
                <xsl:apply-templates select="tei:support/descendant::tei:material" mode="Schlagzeile"/>
            </xsl:when>
            <xsl:when test="@material = 'perg' ">
                <xsl:text>Pergament</xsl:text>
            </xsl:when>
            <xsl:when test="@material = 'chart' ">
                <xsl:text>Papier</xsl:text>
            </xsl:when>
            <xsl:when test="@material = 'papyrus' ">
                <xsl:text>Papyrus</xsl:text>
            </xsl:when>
            <xsl:when test="(@material = 'mixed') and (normalize-space(tei:support/tei:p[. = tei:material]) != '')">
                <xsl:value-of select="tei:support/tei:p[. = tei:material]"/>
            </xsl:when>
            <xsl:when test="(@material = 'mixed')">
                <xsl:value-of select="tei:support"/>
            </xsl:when>
        </xsl:choose>
        <xsl:apply-templates select="descendant::tei:extent" mode="Schlagzeile"/>
    </xsl:template>
    <xsl:template match="tei:table[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <table>
            <xsl:if test="@rend = 'rules'">
                <xsl:attribute name="style" select=" 'border: 1px solid;' "/>
            </xsl:if>
            <xsl:apply-templates/>
        </table>
    </xsl:template>
    <xsl:template match="tei:textLang[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="parent::tei:msContents">
                <p>
                    <xsl:attribute name="class">textLang</xsl:attribute>
                    <xsl:apply-templates/>
                    <xsl:call-template name="writePunctuation"/>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
                <xsl:call-template name="writePunctuation"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:textLang[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="condensed">
        <xsl:apply-templates mode="condensed"/>
        <xsl:call-template name="writePunctuation"/>
    </xsl:template>
    <xsl:template match="tei:title[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:choose>
            <xsl:when test="parent::tei:head">
                <xsl:if test="parent::tei:head/preceding-sibling::tei:head/tei:title">
                    <xsl:value-of select="$Trennzeichen"/>
                </xsl:if>
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="not(parent::tei:bibl) and not(@type = 'sub')">
                <span>
                    <xsl:attribute name="class">titlemain</xsl:attribute>
                    <xsl:if test=" @rend = 'supplied' and not(preceding-sibling::tei:author[ @rend = 'supplied' ]) ">
                        <xsl:text>[</xsl:text>
                    </xsl:if>
                    <xsl:apply-templates/>
                    <xsl:if test=" @rend = 'supplied' ">
                        <xsl:text>]</xsl:text>
                    </xsl:if>
                </span>
            </xsl:when>
            <xsl:when test="not(parent::tei:bibl)">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:when test="parent::tei:bibl">
                <xsl:choose>
                    <xsl:when test="contains(@n,'ppn') and ($media != 'print-offline')">
                        <a>
                            <xsl:attribute name="target">
                                <xsl:text>_blank</xsl:text>
                            </xsl:attribute>
                            <xsl:attribute name="href">
                                <xsl:value-of select="$opac"/>
                                <xsl:value-of select="substring-after(@n, concat($searchfield, '_'))"/>
                            </xsl:attribute>
                            <xsl:apply-templates/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(text() = '')    and not(following-sibling::node()[1][self::tei:edition])    and not(ancestor::tei:bibl)    and not(parent::tei:head)    and not(parent::tei:note)">
            <xsl:call-template name="writePunctuation"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:title[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="condensed">
        <xsl:choose>
            <xsl:when test="parent::tei:head">
                <xsl:if test="parent::tei:head/preceding-sibling::tei:head/tei:title">
                    <xsl:value-of select="$Trennzeichen"/>
                </xsl:if>
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="not(parent::tei:bibl) and not(@type = 'sub')">
                <span>
                    <xsl:attribute name="class">titlemain</xsl:attribute>
                    <xsl:if test=" @rend = 'supplied' and not(preceding-sibling::tei:author[ @rend = 'supplied' ]) ">
                        <xsl:text>[</xsl:text>
                    </xsl:if>
                    <xsl:apply-templates/>
                    <xsl:if test=" @rend = 'supplied' ">
                        <xsl:text>]</xsl:text>
                    </xsl:if>
                </span>
            </xsl:when>
            <xsl:when test="not(parent::tei:bibl)">
                <span>
                    <xsl:attribute name="class">normal</xsl:attribute>
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:when test="parent::tei:bibl">
                <xsl:choose>
                    <xsl:when test="contains(@n,'ppn') and ($media != 'print-offline')">
                        <a>
                            <xsl:attribute name="target">
                                <xsl:text>_blank</xsl:text>
                            </xsl:attribute>
                            <xsl:attribute name="href">
                                <xsl:value-of select="$opac"/>
                                <xsl:value-of select="substring-after(@n, concat($searchfield, '_'))"/>
                            </xsl:attribute>
                            <xsl:apply-templates/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not(text() = '') and not(following-sibling::node()[1][self::tei:edition]) and not(ancestor::tei:bibl) and not(parent::tei:head)">
            <xsl:call-template name="writePunctuation"/>
        </xsl:if>
        <xsl:text> </xsl:text>
    </xsl:template>
    <xsl:template match="tei:unclear[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
        <xsl:apply-templates/>
        <span>
            <xsl:attribute name="class">normal</xsl:attribute>
            <xsl:text> (?)</xsl:text>
        </span>
        <xsl:if test="following-sibling::node()">
            <xsl:call-template name="writeWhitespace"/>
        </xsl:if>
    </xsl:template>

<!-- benannte Templates -->
    <xsl:template name="writeAuthor">
        <xsl:param name="author"/>
        <p>
            <xsl:attribute name="class">foot</xsl:attribute>
            <xsl:value-of select="$author"/>
        </p>
    </xsl:template>
    <xsl:template name="writeBibliography">
        <hr/>
        <p>
            <xsl:attribute name="class">head</xsl:attribute>
            <xsl:text>Abgekürzt zitierte Literatur</xsl:text>
        </p>
        <table>
            <xsl:attribute name="class">bibliography</xsl:attribute>
            <xsl:for-each select="$bibliography//tei:label    [normalize-space(.) = current()//tei:abbr[parent::tei:bibl[not(ancestor::tei:source)]]     [not(ancestor::tei:list[@type = 'bibliography'])]     [not(preceding-sibling::tei:label)]/normalize-space(.)]">
                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="if (starts-with(., tei:hi[@rend = 'sup'])) then substring-after(lower-case(.), tei:hi[@rend = 'sup']) else lower-case(.)"/>
                <tr>
                    <td>
                        <xsl:attribute name="style">vertical-align:top</xsl:attribute>
                        <!--<xsl:attribute name="nowrap">nowrap</xsl:attribute>-->
                        <xsl:choose>
                            <xsl:when test="contains($media,'print')">
                                <span>
                                    <xsl:attribute name="class">author</xsl:attribute>
                                    <xsl:apply-templates/>
                                </span>
                            </xsl:when>
                            <xsl:when test="contains(parent::tei:item/@xml:id, 'opac_')">
                                <a>
                                    <xsl:attribute name="href">
                                        <xsl:value-of select="$opac"/>
                                        <xsl:value-of select="$searchForPPN"/>
                                        <xsl:value-of select="substring-after(parent::tei:item/@xml:id, 'opac_')"/>
                                    </xsl:attribute>
                                    <xsl:attribute name="name">
                                        <xsl:value-of select="translate(.,' ()','_')"/>
                                    </xsl:attribute>
                                    <span>
                                        <xsl:attribute name="class">author</xsl:attribute>
                                        <xsl:apply-templates/>
                                    </span>
                                </a>
                            </xsl:when>
                            <xsl:when test="contains(parent::tei:item/@xml:id, 'gbv_')">
                                <a>
                                    <xsl:attribute name="href">
                                        <xsl:value-of select="$opac"/>
                                        <xsl:value-of select="substring-after(parent::tei:item/@xml:id, 'gbv_')"/>
                                    </xsl:attribute>
                                    <xsl:attribute name="name">
                                        <xsl:value-of select="translate(.,' ()','_')"/>
                                    </xsl:attribute>
                                    <span>
                                        <xsl:attribute name="class">author</xsl:attribute>
                                        <xsl:apply-templates/>
                                    </span>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <a name="{translate(.,' ()','_')}"/>
                                <span>
                                    <xsl:attribute name="class">author</xsl:attribute>
                                    <xsl:apply-templates/>
                                </span>
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                    <td>
                        <xsl:apply-templates select="following-sibling::tei:bibl[1]"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        <xsl:if test="($mode = 'test') and //tei:abbr[parent::tei:bibl][not(. = $bibliography//tei:label)][not(substring-after(@corresp, '#') = //tei:bibl/@xml:id)]">
            <hr/>
            <p>
                <xsl:attribute name="style">color:red</xsl:attribute>
                <xsl:text>Abgekürzte, aber nicht nachgewiesene Literatur</xsl:text>
            </p>
            <ul>
                <xsl:for-each select="distinct-values(//tei:abbr[parent::tei:bibl][not(. = $bibliography//tei:label)])">
                    <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes" select="current()"/>
                    <li>
                        <xsl:value-of select="concat('&#34;', ., '&#34;')"/>
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>
    <xsl:template name="writeDate">
        <xsl:param name="date"/>
        <xsl:analyze-string select="$date" regex="(\d+)-(\d+)-(\d+)">
            <xsl:matching-substring>
                <xsl:value-of select="concat(number(regex-group(3)), '.', number(regex-group(2)), '.', number(regex-group(1)))"/>
            </xsl:matching-substring>
            <xsl:non-matching-substring>
                <xsl:analyze-string select="$date" regex="--(\d+)-(\d+)">
                    <xsl:matching-substring>
                        <xsl:value-of select="concat(number(regex-group(2)), '.', number(regex-group(1)))"/>
                    </xsl:matching-substring>
                    <xsl:non-matching-substring>
                        <xsl:value-of select="$date"/>
                    </xsl:non-matching-substring>
                </xsl:analyze-string>
            </xsl:non-matching-substring>
        </xsl:analyze-string>
    </xsl:template>
    <!-- war: name="Fusszeile"
<xsl:template name="writeFooter">
	<xsl:if test="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt[not(tei:author) and not(tei:title)] or normalize-space(descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:publicationStmt)">
		<hr/>
		<p>
			<xsl:attribute name="class">foot</xsl:attribute>
			<xsl:value-of select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/*[not(self::tei:author) and not(self::tei:title)]"/>
			<br/>
			<xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:publicationStmt/node()"/>
		</p>
	</xsl:if>
</xsl:template>
-->
    <xsl:template name="writeGraphicList">
        <xsl:variable name="graphics">
            <xsl:for-each select="//tei:ref[@type = 'graphic']">
                <xsl:sort lang="de" collation="http://saxon.sf.net/collation?lang=de;alphanumeric=yes"/>
                <xsl:copy-of select="."/>
            </xsl:for-each>
        </xsl:variable>
        <p class="graphicList">
            <xsl:value-of select="translate($graphics/tei:ref[1], '()', '')"/>
            <xsl:text>—</xsl:text>
            <xsl:value-of select="substring-after($graphics/tei:ref[last()], 'Abb. ')"/>
        </p>
    </xsl:template>
    <xsl:template name="Hauptverteiler">
        <xsl:choose>
            <xsl:when test="($catalogueType = 'illum') or (ancestor-or-self::tei:msDesc/@type = 'illum')">
                <xsl:if test="tei:history/tei:provenance[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
                    <p class="provenance_illum">
                        <xsl:text>Provenienz: </xsl:text>
                        <xsl:apply-templates select="tei:history/tei:provenance"/>
                    </p>
                </xsl:if>
                <p class="illum">
                    <xsl:apply-templates select="tei:physDesc/descendant::tei:supportDesc" mode="Schlagzeile"/>
                </p>
                <xsl:apply-templates select="tei:physDesc"/>
                <xsl:if test="tei:msContents[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
                    <p>INHALT</p>
                    <p>
                        <xsl:apply-templates select="tei:msContents"/>
                    </p>
                </xsl:if>
                <xsl:if test="tei:physDesc/tei:decoDesc[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
                    <p>AUSSTATTUNG</p>
                    <xsl:apply-templates select="tei:physDesc/tei:decoDesc"/>
                </xsl:if>
                <xsl:if test="tei:msPart[@rend = 'condensed'] or tei:msFrag">
                    <xsl:call-template name="writeFragments"/>
                </xsl:if>
                <xsl:if test="tei:history/tei:summary[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]">
                    <p>STIL UND EINORDNUNG</p>
                    <xsl:apply-templates select="tei:history/tei:summary"/>
                </xsl:if>
                <xsl:apply-templates select="tei:additional"/>
                <xsl:apply-templates select="tei:msPart[not(@rend = 'condensed')]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="tei:physDesc"/>
                <xsl:if test="tei:msPart[@rend = 'condensed'] or tei:msFrag">
                    <xsl:call-template name="writeFragments"/>
                </xsl:if>
                <xsl:if test="tei:msPart[@type = 'binding']">
                    <xsl:apply-templates select="tei:msPart[@type = 'binding']"/>
                </xsl:if>
                <xsl:apply-templates select="tei:history"/>
                <xsl:apply-templates select="tei:additional"/>
                <xsl:apply-templates select="tei:msContents"/>
                <xsl:apply-templates select="tei:msPart[not(@rend = 'condensed')][not(@type = 'binding')]"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- war: name="JavascriptEinfuegen" -->
    <xsl:template name="writeJavascript">
        <script>
            <xsl:attribute name="type">text/javascript</xsl:attribute><![CDATA[
function Go (select) {
	var wert = select.options[select.options.selectedIndex].value;
	if (wert == "leer")
	{
		select.form.reset();
		parent.focus();
		return;
	} else 
	{
		if (wert == "ende") 
		{
		  top.location.href = parent.location.href;
		} else 
		{
		  parent.location.href = wert;
		  select.form.reset();
		  parent.focus();
		}
	}
}
]]>
        </script>
    </xsl:template>
    <xsl:template name="writeBibliographicHeader">
        <p>
            <xsl:attribute name="class">Hinweis</xsl:attribute>
            <xsl:call-template name="writeBibliographicHeaderContent"/>
        </p>
    </xsl:template>
    <xsl:template name="writeBibliographicHeaderContent">
        <xsl:choose>
            <xsl:when test="descendant-or-self::tei:teiCorpus and ($publishSingleFiles = 'no')">
                <xsl:apply-templates select="descendant-or-self::tei:teiCorpus/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                <xsl:apply-templates select="descendant-or-self::tei:teiCorpus/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:author"/>
                <xsl:apply-templates select="descendant-or-self::tei:teiCorpus/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:respStmt"/>
            </xsl:when>
            <xsl:when test="descendant::tei:msDesc[2] and ($publishSingleFiles = 'no')">
                <xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                <xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:author"/>
                <xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:respStmt"/>
            </xsl:when>
            <xsl:when test="($publishSingleFiles = 'yes') and not(descendant::tei:additional/tei:adminInfo/tei:recordHist/tei:source = '')">
                <xsl:apply-templates select="descendant::tei:additional/tei:adminInfo/tei:recordHist/tei:source"/>
            </xsl:when>
            <xsl:when test="not(descendant::tei:additional/tei:adminInfo/tei:recordHist/tei:source = '')">
                <xsl:apply-templates select="descendant::tei:additional/tei:adminInfo/tei:recordHist/tei:source"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                <xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:author"/>
                <xsl:apply-templates select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:respStmt"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="descendant::tei:fileDesc/tei:titleStmt/tei:funder">
            <br/>
            <xsl:for-each select="descendant::tei:fileDesc/tei:titleStmt/tei:funder[not(.=preceding::tei:fileDesc/tei:titleStmt/tei:funder)]">
                <xsl:if test="preceding-sibling::tei:funder">
                    <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:apply-templates/>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test=" $status = '' or $status = 'vorlaeufig' ">
            <xsl:text> (Vorläufige </xsl:text>
            <xsl:choose>
                <xsl:when test="(count(//tei:msDesc) &gt; 1)">
                    <xsl:text>Beschreibungen)</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>Beschreibung)</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="literaturDB">
        <xsl:param name="xmlid"/>
        <xsl:if test="not($literaturDB='')">
            <xsl:variable name="signatur">
                <xsl:value-of select="translate(substring-before(substring-after($xmlid,concat($repository_short,$collection)),$Katalogisat-Postfix),'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜ','abcdefghijklmnopqrstuvwxyzäöü')"/>
			<!-- muss ersetzt werden durch andere Konstruktion, solange bis XSLT 2.0 auch für MSXML zur Verfügung steht  -->
			<!--
				<xsl:value-of select="lower-case(substring-before(substring-after($xmlid,concat($repository_short,$collection)),$Katalogisat-Postfix))"/>
			-->
            </xsl:variable>
            <p>
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$literaturDB"/>
					<!-- muss ersetzt werden durch andere Konstruktion, solange bis XSLT 2.0 auch für MSXML zur Verfügung steht  -->
					<!--
	<xsl:analyze-string select="$signatur" regex="{$regex}">
		<xsl:matching-substring>
			<xsl:value-of select="regex-group(3)"/>
			<xsl:text>!</xsl:text>
			<xsl:value-of select="regex-group(1)"/>
			<xsl:value-of select="regex-group(2)"/>
			<xsl:text>!</xsl:text>
			<xsl:value-of select="regex-group(4)"/>
		</xsl:matching-substring>
	</xsl:analyze-string>
-->
                    </xsl:attribute>
                    <xsl:text>Neuere Literatur</xsl:text>
                </a>
                <xsl:text> wird in der Handschriftendokumentation nachgewiesen.</xsl:text>
            </p>
        </xsl:if>
    </xsl:template>
    <xsl:template name="locus-verlinken">
        <xsl:param name="attribute"/>
        <xsl:param name="content"/>
        <xsl:variable name="facsID">
            <xsl:choose>
                <xsl:when test="ancestor::tei:TEI/descendant::tei:ptr[@type='purl']">
                    <xsl:value-of select="substring-before(substring-after(ancestor::tei:TEI/descendant::tei:ptr[@type='purl'][contains(@target, 'start.htm')]/@target, concat($collection, '/')), '/start.htm')"/>
                </xsl:when>
                <xsl:when test="ancestor::tei:msDesc/@xml:id">
                    <xsl:value-of select="substring-before(substring-after(ancestor::tei:msDesc/@xml:id, concat($collection, '_')), '_tei-msDesc')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="substring-before(substring-after(ancestor::tei:TEI/@xml:id, concat($collection, '_')), '_tei-msDesc')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="xmlid">
            <xsl:choose>
                <xsl:when test="ancestor::tei:msDesc/@xml:id">
                    <xsl:value-of select="substring-before(substring-after(ancestor::tei:msDesc/@xml:id, concat($collection, '_')), '_tei-msDesc')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="substring-before(substring-after(ancestor::tei:TEI/@xml:id, concat($collection, '_')), '_tei-msDesc')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="facsimile">
            <xsl:choose>
                <xsl:when test="ancestor-or-self::tei:TEI/tei:facsimile">
                    <xsl:copy-of select="ancestor-or-self::tei:TEI/tei:facsimile"/>
                </xsl:when>
                <xsl:when test="doc-available('tei-msDesc.xml') and doc('tei-msDesc.xml')//tei:facsimile">
                    <xsl:copy-of select="doc('tei-msDesc.xml')//tei:facsimile"/>
                </xsl:when>
                <xsl:when test="doc-available($facsimileData)">
                    <xsl:copy-of select="doc($facsimileData)"/>
                </xsl:when>
                <xsl:when test="doc-available(concat($server, $collection, '/', $facsID, '/', $facsimileData))">
                    <xsl:copy-of select="doc(concat($server, $collection, '/', $facsID, '/', $facsimileData))"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="catalog">
            <xsl:choose>
                <xsl:when test="substring-after(ancestor-or-self::tei:TEI/@xml:id, 'tei-msDesc') ne ''">
                    <xsl:value-of select="concat('&amp;catalog=', substring-after(ancestor-or-self::tei:TEI/@xml:id, 'tei-msDesc_'))"/>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=$attribute]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=$attribute]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=substring-before($attribute,'a')]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=substring-before($attribute,'a')]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=substring-before($attribute,'b')]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=substring-before($attribute,'b')]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=substring-before($attribute,'c')]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=substring-before($attribute,'c')]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=substring-before($attribute,'d')]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=substring-before($attribute,'d')]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=concat($attribute,'r')]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=concat($attribute,'r')]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$facsimile/*:facsimile/*:graphic/@n[.=concat($attribute,'v')]">
                <a href="?db=mss&amp;list=ms&amp;id={$xmlid}{$catalog}&amp;image={substring-after($facsimile/*:facsimile/*:graphic[@n=concat($attribute,'v')]/@xml:id, concat($facsID,'_'))}">
                    <xsl:value-of select="$content"/>
                </a>
            </xsl:when>
            <xsl:when test="$attribute = //*:facsimile/*:graphic/@n">
                <a href="{$xmlid}/{$startfile}{$imageParameter}{substring-after(//*:facsimile/*:graphic[@n=$attribute]/@xml:id, concat(substring-before(substring-after(//tei:msDesc/@xml:id, concat($collection, '_')), '_tei-msDesc'), '_'))}">
                    <xsl:value-of select="$attribute"/>
                </a>
            </xsl:when>
            <xsl:when test="@rend">
                <span>
                    <xsl:call-template name="attr-rend-verarbeiten">
                        <xsl:with-param name="value" select="@rend"/>
                    </xsl:call-template>
                    <xsl:value-of select="$content"/>
                </span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$content"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="writeFragments">
        <div class="fragments">
            <xsl:choose>
                <xsl:when test="contains(tei:msPart[@rend = 'condensed'][1]/tei:msIdentifier/tei:idno,'Fragment')"/>
                <xsl:when test="tei:msPart[@rend = 'condensed'][2] or tei:msFrag[2]">
                    <xsl:text>Fragmente: </xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>Fragment: </xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="not(tei:msFrag[2]) and not(tei:msPart[@rend = 'condensed'][2])">
                    <xsl:for-each select="tei:msFrag | tei:msPart[@rend = 'condensed']">
                        <xsl:if test="not(normalize-space(tei:msIdentifier/*) = string(position()))">
                            <xsl:value-of select="concat(normalize-space(tei:msIdentifier/*),'. ')"/>
                        </xsl:if>
                        <xsl:apply-templates select="tei:head/*" mode="condensed"/>
                        <xsl:apply-templates select="tei:physDesc/*" mode="condensed"/>
                        <xsl:apply-templates select="*[not(self::tei:msIdentifier) and not(self::tei:head) and not(self::tei:physDesc)]" mode="condensed"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <ol>
                        <xsl:attribute name="class">condensed</xsl:attribute>
                        <xsl:for-each select="tei:msFrag | tei:msPart[@rend = 'condensed']">
                            <li>
                                <xsl:if test="not(normalize-space(tei:msIdentifier/*) = string(position()))">
                                    <xsl:value-of select="concat(normalize-space(tei:msIdentifier/*),'. ')"/>
                                </xsl:if>
                                <xsl:apply-templates select="tei:head/*" mode="condensed"/>
                                <xsl:apply-templates select="tei:physDesc/*" mode="condensed"/>
                                <xsl:apply-templates select="*[not(self::tei:msIdentifier) and not(self::tei:head) and not(self::tei:physDesc)]" mode="condensed"/>
                            </li>
                        </xsl:for-each>
                    </ol>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    <xsl:template match="tei:additions | tei:bibl | tei:catchwords | tei:condition | tei:decoNote |   tei:foliation[not(tei:p)] |   tei:handNote[not(tei:p)] | tei:head |   tei:material | tei:measure | tei:musicNotation[not(tei:p)] |   tei:origDate | tei:physDesc | tei:scriptNote" mode="condensed">
        <xsl:apply-templates mode="condensed"/>
        <xsl:call-template name="writePunctuation"/>
        <xsl:text> </xsl:text>
    </xsl:template>
    <xsl:template match="tei:extent |   tei:foliation[tei:p] |   tei:handNote[tei:p] |   tei:musicNotation[tei:p] |   tei:layoutDesc | tei:locusGrp |   tei:objectDesc |   tei:scriptDesc | tei:supportDesc | tei:support" mode="condensed">
        <xsl:apply-templates mode="condensed"/>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template match="tei:dimensions[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="condensed">
        <xsl:if test="(@type = 'written') and not(contains(preceding-sibling::text()[1], 'Schriftraum'))">
            <xsl:text>Schriftraum: </xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="ancestor::tei:accMat or ancestor::tei:msPart[@rend = 'condensed'] or ancestor::tei:msFrag">
                <xsl:apply-templates mode="#current"/>
                <xsl:choose>
                    <xsl:when test="tei:height/@unit or tei:width/@unit or tei:depth/@unit"/>
                    <xsl:when test="@unit">
                        <xsl:value-of select="concat(' ', @unit)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(@type = 'leaf') and parent::tei:extent[ancestor::tei:physDesc/parent::tei:msDesc]"/>
            <xsl:otherwise>
                <xsl:apply-templates mode="#current"/>
                <xsl:choose>
                    <xsl:when test="tei:height/@unit or tei:width/@unit or tei:depth/@unit"/>
                    <xsl:when test="@unit">
                        <xsl:value-of select="concat(' ', @unit)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="writePunctuation"/>
        <xsl:text> </xsl:text>
    </xsl:template>
    <xsl:template match="tei:height[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default condensed">
        <xsl:value-of select="."/>
        <xsl:if test="@unit and not(../tei:width/@unit) and not(../tei:depth/@unit)">
            <xsl:text> </xsl:text>
            <xsl:value-of select="@unit"/>
        </xsl:if>
        <xsl:if test="../tei:width or ../tei:depth">
            <xsl:text> × </xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:width[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default condensed">
        <xsl:value-of select="."/>
        <xsl:if test="@unit and not(../tei:depth/@unit)">
            <xsl:text> </xsl:text>
            <xsl:value-of select="@unit"/>
        </xsl:if>
        <xsl:if test="../tei:depth">
            <xsl:text> × </xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:depth[not(normalize-space(.)='') or descendant::tei:ptr[@target or @cRef]]" mode="#default condensed">
        <xsl:value-of select="."/>
        <xsl:if test="@unit">
            <xsl:text> </xsl:text>
            <xsl:value-of select="@unit"/>
        </xsl:if>
    </xsl:template>
    <xsl:template name="writePunctuation">
<!--
    	not(starts-with(substring-after(.., normalize-space(.)), ']'))">
		(self::tei:msItem and (not(parent::tei:msItem)) or not(ends-with(normalize-space(parent::*), normalize-space(.)))) and
-->
        <xsl:if test="   not(descendant::tei:gap[not(following-sibling::text())]) and   not(descendant-or-self::node()[@rend = 'dottedEnd']) and   not(descendant-or-self::node()[(@type = 'recipe') or (@type = 'sermon')]) and   not(ends-with(normalize-space(.), ',')) and   not(ends-with(normalize-space(.), ';')) and   not(ends-with(normalize-space(.), '.')) and   not(ends-with(normalize-space(.), ':')) and   not(ends-with(normalize-space(.), '!')) and   not(ends-with(normalize-space(.), '?')) and   not(starts-with(substring-after(parent::node(), normalize-space(.)), ',')) and   not(starts-with(substring-after(parent::node(), normalize-space(.)), ';')) and   not(starts-with(substring-after(parent::node(), normalize-space(.)), '.')) and   not(starts-with(substring-after(parent::node(), normalize-space(.)), ':')) and   not(starts-with(substring-after(parent::node(), normalize-space(.)), '!')) and   not(starts-with(substring-after(parent::node(), normalize-space(.)), '?')) and   not(self::tei:index) and    not((self::tei:msItem or self::tei:decoNote) and    (    ends-with(normalize-space(.), descendant::tei:explicit[last()]) or     ends-with(normalize-space(.), descendant::tei:finalRubric[last()]) or     ends-with(normalize-space(.), descendant::tei:colophon[last()]) or     ends-with(normalize-space(.), descendant::tei:index[last()]))    ) and   not(parent::tei:abbr) and    not(parent::tei:author[following-sibling::tei:title]) and    not(parent::tei:ptr) and    not(parent::tei:ref) and   not(parent::tei:rubric) and    not(parent::tei:incipit) and    not(parent::tei:quote) and    not(parent::tei:explicit) and    not(parent::tei:finalRubric) and    not(parent::tei:colophon) and   not(parent::tei:title) and    not(parent::tei:note) and    not(parent::tei:item)">
            <xsl:choose>
                <xsl:when test="self::tei:item">
                    <xsl:text>,</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>.</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:call-template name="writeWhitespace"/>
    </xsl:template>
    <xsl:template name="writeBibliographicalSource">
        <div>
            <xsl:attribute name="class">source</xsl:attribute>
            <xsl:apply-templates select="descendant::tei:source/tei:bibl"/>
        </div>
    </xsl:template>
    <xsl:template name="writeMsHeading">
        <xsl:param name="xmlid"/>
        <xsl:if test="tei:head[*[not(self::tei:note)]]">
            <p>
                <xsl:attribute name="class">head</xsl:attribute>
                <xsl:call-template name="writeMsHeadingContent">
                    <xsl:with-param name="xmlid" select="$xmlid"/>
                </xsl:call-template>
            </p>
        </xsl:if>
    </xsl:template>
    <xsl:template name="writeMsHeadingContent">
        <xsl:param name="xmlid"/>
        <xsl:choose>
            <xsl:when test="tei:head/tei:title">
                <xsl:apply-templates select="tei:head/tei:title"/>
            </xsl:when>
            <xsl:when test="not(tei:head/tei:title) and tei:msIdentifier/tei:msName">
                <xsl:apply-templates select="tei:msIdentifier/tei:msName"/>
            </xsl:when>
            <xsl:when test="count(ancestor-or-self::tei:msDesc/descendant::tei:msItem[tei:author or tei:title]) lt 4">
                <xsl:for-each select="tei:msContents/tei:msItem[tei:author or tei:title] | tei:msPart/tei:msContents/tei:msItem[tei:author or tei:title]">
                    <xsl:if test="preceding-sibling::tei:msItem[tei:author or tei:title]">
                        <xsl:value-of select="$Trennzeichen"/>
                    </xsl:if>
                    <xsl:value-of select="tei:author"/>
                    <xsl:if test="tei:author and tei:title">
                        <xsl:text>: </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="tei:title"/>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="writeHTMLhead">
        <head>
            <title>
                <xsl:choose>
                    <xsl:when test="descendant-or-self::tei:teiCorpus">
                        <xsl:value-of select="descendant-or-self::tei:teiCorpus/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="descendant-or-self::tei:TEI/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
            <meta name="DC.Title">
                <xsl:attribute name="content">
                    <xsl:choose>
                        <xsl:when test="descendant-or-self::tei:teiCorpus">
                            <xsl:value-of select="descendant-or-self::tei:teiCorpus/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="descendant-or-self::tei:TEI[1]/tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </meta>
            <xsl:for-each select="descendant-or-self::tei:fileDesc/tei:titleStmt/tei:author[not(.=preceding::tei:fileDesc/tei:titleStmt/tei:author)]">
                <meta name="DC.Creator" content="{normalize-space(.)}"/>
            </xsl:for-each>
            <xsl:for-each select="descendant-or-self::tei:fileDesc/tei:titleStmt/tei:funder[not(.=preceding::tei:fileDesc/tei:titleStmt/tei:funder)]">
                <meta name="DC.Contributors" content="{normalize-space(.)}"/>
            </xsl:for-each>
            <xsl:for-each select="descendant-or-self::tei:fileDesc/tei:titleStmt/tei:respStmt[not(.=preceding::tei:fileDesc/tei:titleStmt/tei:respStmt)]">
                <meta name="DC.Contributors">
                    <xsl:attribute name="content">
                        <xsl:apply-templates select="." mode="meta"/>
                    </xsl:attribute>
                </meta>
            </xsl:for-each>
            <link rel="stylesheet" type="text/css" href="{$cssFile}"/>
        </head>
    </xsl:template>
    <xsl:template name="writeToC">
        <ol>
            <xsl:apply-templates select="descendant::tei:body/tei:div[tei:head]" mode="toc"/>
        </ol>
    </xsl:template>
    <xsl:template match="tei:div[tei:head[not(@rend='noToC')]]" mode="toc">
        <xsl:param name="toc"/>
        <li>
            <a href="#{encode-for-uri(tei:head)}">
                <xsl:value-of select="tei:head"/>
            </a>
            <xsl:if test="tei:div[tei:head[not(@rend='noToC')]]">
                <ol>
                    <xsl:apply-templates select="tei:div[tei:head[not(@rend='noToC')]]" mode="toc">
                        <xsl:with-param name="toc" select="concat('_', count(preceding-sibling::tei:div[tei:head[not(@rend='noToC')]]) + 1)"/>
                    </xsl:apply-templates>
                </ol>
            </xsl:if>
        </li>
    </xsl:template>
    <!--
    <xsl:template match="tei:divGen[@type = 'bibliography']">
        <xsl:if test="($listAbbreviatedTitles = 'yes')              and $bibliography//tei:label[. = current()/following::tei:div[tei:head = 'Katalog']/descendant::tei:abbr[parent::tei:bibl[not(ancestor::tei:source)]][not(ancestor::tei:list[@type = 'bibliography'])]]">
            <xsl:call-template name="writeBibliography"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:divGen[@type = 'index'][@subtype = 'citedMs']">
        <xsl:call-template name="writeIndexCitedMs"/>
    </xsl:template>
    <xsl:template match="tei:divGen[@type = 'index'][@subtype = 'illum']">
        <xsl:call-template name="writeIndexIllum"/>
    </xsl:template>
    <xsl:template match="tei:divGen[@type = 'toc']">
        <h1>Inhaltsverzeichnis</h1>
        <xsl:choose>
            <xsl:when test="$mode = 'print'">
                <ol class="ebene1">
                    <xsl:apply-templates select="following-sibling::tei:div[not(tei:head[@rend='noToC'])]" mode="toc"/>
                </ol>
            </xsl:when>
            <xsl:otherwise>
                <details>
                    <summary>aufklappen</summary>
                    <ol class="ebene1">
                        <xsl:apply-templates select="following-sibling::tei:div[not(tei:head[@rend='noToC'])]" mode="toc"/>
                    </ol>
                </details>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="tei:divGen[@type = 'concordanceCatNo']">
        <table>
            <thead>
                <tr>
                    <th>Signatur</th>
                    <th>Katalognummer</th>
                </tr>
            </thead>
            <tbody>
                <xsl:for-each select="root()/descendant::tei:div[tei:head = 'Katalog']/descendant::tei:msDesc">
                    <xsl:sort select="tei:msIdentifier/tei:idno/@sortKey"/>
                    <xsl:variable name="concordance">
                        <entry>
                            <idno>
                                <xsl:choose>
                                    <xsl:when test="starts-with(tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix)">
                                        <xsl:value-of select="substring-after(tei:msIdentifier/tei:idno, $ignoreInIdnoPraefix)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="tei:msIdentifier/tei:idno"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </idno>
                            <catNo>
                                <xsl:value-of select="count(preceding::tei:msDesc) + 1"/>
                            </catNo>
                        </entry>
                    </xsl:variable>
                    <tr>
                        <td>
                            <xsl:value-of select="$concordance/entry/idno"/>
                        </td>
                        <td>
                            <xsl:value-of select="$concordance/entry/catNo"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template match="tei:divGen[@type = 'index'][not(@subtype)]">
        <xsl:call-template name="writeIndexGeneral"/>
    </xsl:template>
    -->
    <xsl:template name="writeWhitespace">
        <xsl:if test="(   not(ends-with(normalize-space(parent::*), normalize-space(.))) and     not(starts-with(following-sibling::node()[1],')')) and   not(starts-with(following-sibling::node()[1],',')) and   not(starts-with(following-sibling::node()[1],';')) and   not(starts-with(following-sibling::node()[1],'.')) and   not(starts-with(following-sibling::node()[1],':')) and   not(starts-with(following-sibling::node()[1],'-')) and   not(starts-with(following-sibling::node()[1],'–')) and   not(starts-with(following-sibling::node()[1],']'))   )    or starts-with(following-sibling::node()[1],'…')    or (self::tei:gap and (following-sibling::node()[1] = following-sibling::*[1]))    or (self::tei:collation and preceding-sibling::*)    or (parent::tei:locusGrp and not(following-sibling::tei:locus))   or self::tei:title[parent::tei:msItem]">
            <xsl:text> </xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:back | tei:body | tei:publicationStmt | tei:text | tei:titleStmt" mode="#all"/>
    <xsl:template match="tei:index" mode="#default condensed Einzeldatei meta msPart Schlagzeile Schlagzeile-illum Signatur"/>
    <xsl:template match="tei:settlement[. = $ignoreInSettlement] |   tei:institution[. = $ignoreInInstitution] |   tei:repository[. = $ignoreInRepository] |   tei:collection[. = $ignoreInCollection]" mode="Schlagzeile"/>
    <xsl:template match="tei:settlement[not(. = $ignoreInSettlement)] |   tei:institution[not(. = $ignoreInInstitution)] |   tei:repository[not(. = $ignoreInRepository)] |   tei:collection[not(. = $ignoreInCollection)]" mode="Schlagzeile">
        <xsl:if test="parent::tei:altIdentifier and not(. = ancestor::tei:msIdentifier/node()[name() = current()/name()])">
            <xsl:value-of select="."/>
            <xsl:if test="preceding-sibling::tei:settlement     or preceding-sibling::tei:institution     or preceding-sibling::tei:repository">
                <xsl:text>, </xsl:text>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template match="tei:msContents | tei:msIdentifier | tei:reg">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="tei:condition | tei:foliation">
        <xsl:apply-templates/>
        <xsl:call-template name="writePunctuation"/>
    </xsl:template>
    <xsl:template match="*[(normalize-space(.)='') and not(descendant::tei:ptr[@target or @cRef])][not(self::tei:gap)][not(self::tei:lb)]" mode="#all"/>
    <xsl:template name="attr-rend-verarbeiten">
        <xsl:param name="value"/>
        <xsl:if test="($value = 'sup') or contains($value,'small-caps') or contains($value,'italic') or (local-name()='incipit') or (local-name()='explicit') or (local-name()='quote') or contains($value,'underline') or contains($value,'bold')">
            <xsl:attribute name="style">
                <xsl:if test="$value = 'sup' ">vertical-align:super;font-size:80%;margin-left:2px;</xsl:if>
                <xsl:if test=" contains($value,'small-caps') ">font-variant:small-caps;</xsl:if>
                <xsl:if test=" contains($value,'italic')     or (local-name()='incipit')     or (local-name()='explicit')     or (local-name()='quote')">font-style:italic;</xsl:if>
                <xsl:if test=" contains($value,'underline') ">text-decoration:underline;</xsl:if>
                <xsl:if test=" contains($value,'bold') ">font-weight:bold;</xsl:if>
            </xsl:attribute>
        </xsl:if>
        <xsl:if test="contains($value,'normal')">
            <xsl:attribute name="class">normal</xsl:attribute>
        </xsl:if>
        <xsl:if test="contains($value,'dots-before')">...</xsl:if>
    </xsl:template>
</xsl:stylesheet>
