<?php include("parts/header.php"); ?> 

    <header>
        <div class="container">

            <!-- News Section -->
            <div id="news">
                <span class="de">Aktuell:
                  <a href="pcp-reloaded/de/">
Call for Papers/Call for Data: Professorale Karrieremuster Reloaded – Daten, Methoden und Analysen der digitalen Frühneuzeitforschung zur Universitäts- und Gelehrtenge­schichte
</a>
                </span>
                <span class="en">News:
                  <a href="pcp-reloaded/en/">
Call for Papers/Call for Data: Professorial Career Patterns Reloaded – Data, Methods and Analysis of Digital Humanities Research in the Field of Early Modern Academic History
</a>
                </span>
                <span onclick="jQuery('#news').slideUp()">&#10006;</span>
             </div>


            <div class="row">
                <div class="col-lg-12">
                    <img width="60%" class="img-responsive" src="img/pcp-logo.gif" alt="">
                    <div class="intro-text">
                        <span class="de name">Professorale Karrieremuster der Frühen Neuzeit</span>
                        <span class="en name">Early Modern Professorial Career Patterns</span>

                        <hr class="star-light">
                        <span class="de skills">Entwicklung einer wissenschaftlichen Methode zur Forschung auf online verfügbaren und verteilten Forschungsdatenbanken der Universitätsgeschichte.</span>
                        <span class="en skills">Methodological research on online databases of academic history</span>

                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Partner Section -->
    <?php echo section_begin("Partner","Partners",0); ?> 

    <!-- Beginn Partner Content -->
		<div class="col-lg-4">
                    <p><b>​Hochschule für Technik, Wirtschaft und Kultur Leipzig (HTWK)</b> <span class="en">University of Applied Science</span> <a target="_blank" href="http://htwk-leipzig.de">↗</a>
<span class="de">Forschungsgruppe</span><span class="en">Research Group</span> Agile Knowledge Engineering and Semantic Web</p>
<ul><li>Thomas Riechert <a target="_blank" href="http://aksw.org/ThomasRiechert">↗</a></li><li>Edgard Marx <a target="_blank" href="http://aksw.org/EdgardMarx">↗</a></li></ul>
                </div>
                <div class="col-lg-3">
                    <p><b>Herzog August Bibliothek Wolfenbüttel (HAB)</b> <a target="_blank" href="http://hab.de/">↗</a></p>
<ul><li>Ulrike Gleixner <a target="_blank" href="http://www.hab.de/de/home/ueber-uns/kontakte-und-organisation/prof-dr-ulrike-gleixner.html">↗</a></li><li>Hartmut Beyer <a target="_blank" href="http://www.hab.de/de/home/ueber-uns/kontakte-und-organisation/dr-hartmut-beyer.html">↗</a></li><li>Jennifer Blanke <a target="_blank" href="http://www.hab.de/de/home/ueber-uns/kontakte-und-organisation/jennifer-blanke.html">↗</a></li></ul>



                </div>
                <div class="col-lg-5">
                    <p><b><span class="de">Netzwerk deutscher Professorenkataloge</span><span class="en">Network of german professors catalogs</span></b></p>
		    <ul><li>Catalogus Professorum Lipsiensium <a target="_blank" href="http://research.uni-leipzig.de/catalogus-professorum-lipsiensium/">↗</a></li>
                    <li>Professorenkatalog Universität Helmstedt <a target="_blank" href="http://uni-helmstedt.hab.de/index.php?cPage=6&sPage=prof">↗</a></li>
                    <li>Bamberger Professorinnen- und Professorenkatalog <a target="_blank" href="https://www.uni-bamberg.de/arch/projekte/professorinnen-und-professorenkatalog/">↗</a></li>
                    <li>Kieler Gelehrtenverzeichnis <a target="_blank" href="https://gelehrtenverzeichnis.de">↗</a></li>
                    </ul>
		</div>

    <!-- End Partner Content -->
    <?php echo section_end(); ?> 

	<div style="text-align: center; margin-top: -40px; margin-bottom: 15px;">
	<p class="de">Das Projekt ist gefördert durch die Deutsche Forschungsgemeinschaft (DFG) - Projektnummer: <a href="http://gepris.dfg.de/gepris/projekt/317044652" target="_bank">317044652</a></p>
	<p class="en">The project is funded by Deutsche Forschungsgemeinschaft (DFG) - Project-number: <a href="http://gepris.dfg.de/gepris/projekt/317044652" target="_bank">317044652</a></p>
	</div>


    <!-- Ziele Section -->
    <?php echo section_begin("Projektziele","Objectives",1); ?> 

    <!-- Beginn Ziele Content -->
                    <p class="de">Die Fragestellung 
nach Karrieremustern deutscher Professoren im 16. bis 18. Jahrhundert ist beispielhaft für die 
prosopographische Forschung, in welcher die Auswertung von gesammelten Informationen über Gruppen 
historischer Personen erfolgt. Dabei bezieht sich die Fragestellung auf eine Epoche, welche durch die 
Professorenkataloge der im Projekt kooperierenden Partner, den Catalogus Professorum Lipsiensium und den 
Helmstedter Professorenkatalog, abgedeckt ist. Innerhalb des geplanten Projektes soll eine Methode 
entwickelt werden, welche bekannte Forschungsmethoden aus den Geisteswissenschaften und der Informatik 
zusammenführt. Eine Vorarbeit stellt hier der Vorschlag für das Heloise Common Research Modell (HCRM) 
zur projektübergreifenden Forschung im Bereich der Universitätsgeschichte im Europäischen Netzwerk Heloise 
dar. Das HCRM, konzipiert als Schichtenarchitektur, erlaubt die unabhängige Forschung und Entwicklung auf 
den drei Abstraktionsebenen Repository Layer, Application Layer und Research Interface Layer. Im Rahmen 
des geplanten Forschungsvorhabens soll eine Methode auf dem HCRM entwickelt und durch die 
Beantwortung der Forschungsfrage evaluiert werden. </p>

<p class="en">The Leipzig University of Applied Science (HTWK Leipzig) with the research group Agile Knowledge
Engineering and Semantic Web (AKSW) and the Herzog August Library in Wolfenbüttel (HAB) run the research project,
in cooperation with partners from the Working Group of German Professor catalogs and the European research network
for academic history - Héloïse. The project uses independent online databases for research in the field of
prosopography, which is the study and evaluation of collected information on groups of historical persons.
This project focuses on German professors' career patterns from 16th until 18th century. The proposed research employs
databases that have previously been produced by both project
partners, namely the Catalogus Professorum Lipsiensium and the Professorum Helmstadiensium. This proposed project
will develop a new research method that combines well-known research methods from the humanities and
computer science. In preliminary work AKSW proposed the Heloise Common Research
Model (HCRM) for cross-project research in the field of university history, within the European research network
Heloise. HCRM is conceived as a layered architecture, framing the research within the following abstract
layers: the Repository Layer, the Application Layer and the Research Interface Layer. As part of the proposed
research project a method will be developed based on HCRM and be evaluated by studying the research question.
				</p>

    <!-- End Ziele Content -->
    <?php echo section_end(); ?> 

    <!-- Portfolio Section -->
    <?php echo section_begin("Portfolio","Portfolio",2,true); ?> 

    <!-- Beginn Portfolio Content -->


                <div class="col-sm-4 portfolio-item">
                    <a href="#portfolioModal1" class="portfolio-link" data-toggle="modal">
                        <div class="caption">
                            <div class="caption-content">
                                <i class="fa fa-search-plus fa-3x">HCRM Proposal</i>
                            </div>
                        </div>
                        <img src="img/portfolio/hcrm-preview.png" class="img-responsive" alt="">
                    </a>
                </div>
                <div class="col-sm-4 portfolio-item">
                    <a href="#portfolioModal2" class="portfolio-link" data-toggle="modal">
                        <div class="caption">
                            <div class="caption-content">
                                <i class="fa fa-search-plus fa-3x">CPL <span class="de">Katalog</span><span class="en">Catalog</span></i>
                            </div>
                        </div>
                        <img src="img/portfolio/cpl-preview.png" class="img-responsive" alt="">
                    </a>
                </div>
                <div class="col-sm-4 portfolio-item">
                    <a href="#portfolioModal3" class="portfolio-link" data-toggle="modal">
                        <div class="caption">
                            <div class="caption-content">
                                <i class="fa fa-search-plus fa-3x">LOD Lifecycle</i>
                            </div>
                        </div>
                        <img src="img/portfolio/LOD-preview.png" class="img-responsive" alt="">
                    </a>
                </div>
                <div class="col-sm-4 portfolio-item">
                    <a href="#portfolioModal4" class="portfolio-link" data-toggle="modal">
                        <div class="caption">
                            <div class="caption-content">
                                <i class="fa fa-search-plus fa-3x">Helmstedt <span class="de">Katalog</span><span class="en">Catalog</span></i>
                            </div>
                        </div>
                        <img src="img/portfolio/helmstedt-preview.png" class="img-responsive" alt="">
                    </a>
                </div>
                <div class="col-sm-4 portfolio-item">
                    <a href="#portfolioModal5" class="portfolio-link" data-toggle="modal">
                        <div class="caption">
                            <div class="caption-content">
                                <i class="fa fa-search-plus fa-3x">amsl. technology</i>
                            </div>
                        </div>
                        <img src="img/portfolio/amsl-preview.png" class="img-responsive" alt="">
                    </a>
                </div>
                <div class="col-sm-4 portfolio-item">
                    <a href="#portfolioModal6" class="portfolio-link" data-toggle="modal">
                        <div class="caption">
                            <div class="caption-content">
                                <i class="fa fa-search-plus fa-3x">DBpedia <span class="de">Extraktion</span><span class="en">Extraction</span></i>
                            </div>
                        </div>
                        <img src="img/portfolio/dbpedia-preview.png" class="img-responsive" alt="">
                    </a>
		</div>
 

    <!-- End Portfolio Content -->
    <?php echo section_end(); ?>
	
	
	<?php echo section_begin("Dataset","Dataset",3); ?> 

    <!-- Beginn DATASET Content -->

		<p>The project is producing a unique dataset and ontology that can be used and further extended for historian research.<br />The current dataset consists of data about scholars at the universities of Helmstedt and Leipzig in the Early Modern period (16th to 18 century).<br />The data was extracted from the Leipzig Professor's Catalogue and the Helmstedt Portal, i.a. the Helmstedt Professor's Catalogue:</p>
		<ul>
		<li><a href="https://catalogus-professorum.org/">https://catalogus-professorum.org/</a></li>
		<li><a href="http://uni-helmstedt.hab.de">http://uni-helmstedt.hab.de</a></li>
		</ul>
		<p>Furthermore, it contains data extracted from the VD16, VD17, and VD18 datasets:</p>
		<ul>
		<li>VD16:&nbsp;<a href="https://www.bsb-muenchen.de/sammlungen/historische-drucke/recherche/vd-16/">https://www.bsb-muenchen.de/sammlungen/historische-drucke/recherche/vd-16/</a></li>
		<li>VD17:&nbsp;<a href="http://www.vd17.de/">http://www.vd17.de/</a></li>
		<li>VD:18:&nbsp;<a href="https://gso.gbv.de/DB=1.65/">https://gso.gbv.de/DB=1.65/</a></li>
		</ul>
		<p>The easiest way of querying and accessing the dataset is by KBox,&nbsp;a distributed data catalogue publishing system that enables to share and query RDF knowledge graphs.&nbsp;For more information on KBox, access&nbsp;<a href="http://github.com/AKSW/KBox">http://github.com/AKSW/KBox</a>. For querying the PCP-On-Web data, download KBox <em>v0.0.2-alpha&nbsp;</em>and use the following command to create your own SPARQL endpoint using the project datasets:</p>
		<blockquote style="background: #eee;  padding: 15px;">java -jar kbox-v0.0.2-alpha.jar -server -kb "http://purl.org/pcp-on-web/ontology,http://purl.org/pcp-on-web/dataset,http://purl.org/pcp-on-web/vd" -install</blockquote>
		<p>Write your SPARQL queries directly on the Web-Client accessible by&nbsp;<a href="http://localhost:8080">http://localhost:8080</a>.</p>
		<p>Notice that the command above includes three datasets:</p>
		<ul>
		<li>The PCP-on-Web ontology:&nbsp; http://purl.org/pcp-on-web/ontology;</li>
		<li>The PCP-on-Web dataset:&nbsp;<em>http://purl.org/pcp-on-web/dataset;</em></li>
		<li>and the VD16, VD17, VD18 datasets:&nbsp;http://purl.org/pcp-on-web/vd.</li>
		</ul>
		<p>You can also query different datasets by restricting -kb command line e.g.&nbsp; -kb "http://purl.org/pcp-on-web/vd" in case you want to query only the VD datasets.</p>
		<p>There is also the option of querying the dataset via command-line:</p>
		<blockquote style="background: #eee;  padding: 15px;">java -jar kbox-v0.0.2-alpha.jar -query "select ?s ?p ?o where {?s ?p?o}" -kb "http://purl.org/pcp-on-web/ontology,http://purl.org/pcp-on-web/dataset,http://purl.org/pcp-on-web/vd" -install</blockquote>
		<p>In the example above, we list all triples (?s ?p ?o) from the dataset. You can also download or report issues in our Github repositories:</p>
		<ul>
		<li>ontology:&nbsp;<a href="https://github.com/pcp-on-web/ontology">https://github.com/pcp-on-web/ontology</a></li>
		<li>dataset:&nbsp;<a href="https://github.com/pcp-on-web/helmstedt-leipzig-dataset">https://github.com/pcp-on-web/helmstedt-leipzig-dataset</a></li>
		</ul>
		<p>If you are a hardcore user and want to download the dataset dump files or keep track of its changes, you can download the dataset at:</p>
		<ul>
		<li>ontology:&nbsp;<a href="https://github.com/pcp-on-web/ontology">https://github.com/pcp-on-web/ontology</a></li>
		<li>dataset:&nbsp;<a href="https://gitlab.imn.htwk-leipzig.de/emarx/pcp-on-web">https://gitlab.imn.htwk-leipzig.de/emarx/pcp-on-web</a></li>
		</ul>

    <!-- End Dataset Content -->
    <?php echo section_end(); ?> 
	

    <!-- Blog Section -->
    <?php echo section_begin("Blog","Blog",4,true); ?> 

    <!-- Beginn Blog Content -->


    <?php
	exec("cat blog.php | grep section_begin",$blog);
	exec("cat blog.php | grep '<p class=\"de\">'",$content_de); 
	exec("cat blog.php | grep '<p class=\"en\">'",$content_en); 

	$i=0;
	
	foreach ($blog as $entry) {

        if ($i<5) {
		    $items = explode('"',$entry);

		    $abstract_de = str_replace('<p ','<span ',$content_de[$i]);
		    $abstract_de = substr($abstract_de, 0, strpos($abstract_de,"<!--more-->")).'</span>'; 
		    $abstract_en = str_replace('<p ','<span ',$content_en[$i]);
		    $abstract_en = substr($abstract_en, 0, strpos($abstract_en,"<!--more-->")).'</span>'; 

		    echo '<p class="entry"><a href="blog.php#'.strtolower(preg_replace('/[^A-Za-z0-9-]+/', '-', $items[1])).'"><span class="de">'.$items[1].'</span><span class="en">'.$items[3].'</span></a> '.$abstract_de.$abstract_en.'<br/><span class="de">Veröffentlicht am </span><span class="en">Published: </span>'.$items[5].'</p>';
        }
        if ($i==5) {
            echo '<p><span class="de"><a href="'.$base.'blog.php#de">Weitere Blogeinträge ...</a></span><span class="en"><a href="'.$base.'blog.php#en">More Articles ...</a></span></p>';
        };
        $i++;
	}
     ?>


    <!-- End Blog Content -->
    <?php echo section_end(); ?>
 
    <!-- Publication Section -->
    <?php echo section_begin("Publikationen","Publications",5); ?> 

    <!-- Beginn Publication Content -->

    <?php include("publications.html"); ?>


    <!-- End Publication Content -->
    <?php echo section_end(); ?>

    <!-- Contact Section -->
    <?php echo section_begin("Kontakt","Contact",5); ?> 

    <!-- Beginn Contact Content -->

            <!-- To configure the contact form email address, go to mail/contact_me.php and update the email address in the PHP file on line 19. -->
            <!-- The form should work on most web servers, but if the form is not working you may need to configure your web server differently. -->
            <form name="sentMessage" id="contactForm" novalidate>
              <div class="control-group">
                <div class="form-group floating-label-form-group controls">
                  <label>Name</label>
                  <input class="form-control" id="name" type="text" placeholder="Name" required data-validation-required-message="Please enter your name.">
                  <p class="help-block text-danger"></p>
                </div>
              </div>
              <div class="control-group">
                <div class="form-group floating-label-form-group controls">
                  <label>Email Address</label>
                  <input class="form-control" id="email" type="email" placeholder="Email Address" required data-validation-required-message="Please enter your email address.">
                  <p class="help-block text-danger"></p>
                </div>
              </div>
              <div class="control-group">
                <div class="form-group floating-label-form-group controls">
                  <label>Phone Number</label>
                  <input class="form-control" id="phone" type="tel" placeholder="Phone Number" required data-validation-required-message="Please enter your phone number.">
                  <p class="help-block text-danger"></p>
                </div>
              </div>
              <div class="control-group">
                <div class="form-group floating-label-form-group controls">
                  <label>Message</label>
                  <textarea class="form-control" id="message" rows="5" placeholder="Message" required data-validation-required-message="Please enter a message."></textarea>
                  <p class="help-block text-danger"></p>
                </div>
              </div>
              <br>
              <div id="success"></div>
              <div class="form-group">
<button type="submit" class="btn btn-success btn-lg" id="sendMessageButton">Send</button>
              </div>
</form>


    <!-- End Contact Content -->
    <?php echo section_end(); ?>



<?php include("parts/footer.php"); ?> 
