    <header>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="intro-text">

                        <span class="en name">Doctoral Symposium on Research on Online Databases in History (RODBH 2019), April 4th-5th 2019, Leipzig</span>

                        <hr class="star-light">
                        <span class="en skills">Paper submission deadline: March 1st, 2019 (extended), Final notification to authors: March, 6th 2019</span><br/>
                        <span class="skills">Call for Papers | <a href="page.php?goto=RODBH2019-AcceptedPapers#en">Accepted Papers</a> |  <a href="page.php?goto=RODBH2019-Agenda#en">Agenda</a> | <a href="page.php?goto=RODBH2019-Publication#en">Publication</a></span>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Partner Section -->
    <?php echo section_begin("Call for Papers","Call for Papers",0); ?> 

    <!-- Beginn Partner Content -->
<p>The doctoral symposium deals with research on online databases in the academic field of
history. It gathers Ph.D. students from the Humanities, Computer Science and Digital
Humanities who are using Semantic Web technologies and are concerned with Ontology
building in their projects. The Doctoral Symposium will provide students with:
<ul>
<li>a scientific environment within an interdisciplinary and international forum to present
their research;</li>
<li>a discussion platform concerning research and methodologies; and further issues;</li>
<li>an overview of the breadth and depth of Data for History;</li>
<li>feedback and suggestions from peers and experienced faculty;</li>
<li>the opportunity to obtain insight into directions for research on online databases in
History taken by other doctoral candidates; and</li>
<li>an opportunity to network with peers and future colleagues.</li>
</ul>
</p><p>
The Doctoral Symposium is hosted by Leipzig University of Applied Science, Faculty of Informatics and Media (HTWK) as part of the Research project <a href="https://pcp-on-web.htwk-leipzig.de" target="_blank">Early Modern Professorial Career Patterns - Methodological research on online databases of academic history</a>, in cooperation with the European Consortium on <a href="http://dataforhistory.org/" target="_blank">Data for History</a>. A general meeting of the DfH Consortium is part of the workshop and includes the application of the <a href="http://ontologies.dataforhistory.org/" target="_blank">OntoMe - Ontology Management Environment</a>, a platform to design vocabularies using ontologies contributed by the participating Ph.D. students.
</p>


<h3>Submission, Eligibility and Review Criteria</h3>

<p>
The paper or abstract submission to the doctoral symposium is open only to Doctoral or Ph.D. Students. Accepted papers or abstracts at the Doctoral Symposium must be presented by the student, for which accommodation and participation are funded by the German Science Foundation (DFG). Travel expenses are reimbursed pro rata. 
</p><p>
Submissions will be judged mainly on relevance, originality, technical quality and clarity. Papers and abstracts must be written in English following the LNI (<a href="https://gi.de/service/publikationen/lni/" target="_blank">Lecture Notes in Informatics</a>) templates in Word or LaTeX provided by Gesellschaft für Informatik e.V. . Papers allowed within the length between 4 and 8 pages, abstracts have to be at least one page. It is planned to publish the peer-reviewed papers. 
</p><p>
The contributions may include a vocabulary of the applied research vocabulary under Creative Commons Attribution 4.0 International Public License ("Public License"), if available in RDF format. All papers should be submitted using <a href="https://easychair.org/cfp/RODBH2019" target="_blank">EasyChair</a>.
</p>	

<h3>Important Dates</h3>

<p><ul><li>Paper Submission Deadline: March 1st, 2019 (extended)</li>
<li>Notification of acceptance: March 6th, 2019</li>
<li>Doctoral Symposium: April 4th to April 5th, 2019</li>
</ul>
</p>

<h3>PC-Chair</h3>
<p><ul><li>Thomas Riechert (Leipzig University of Applied Sciences, Germany, thomas.riechert@htwk-leipzig.de)</li>
<li>Francesco Beretta (CNRS, Le Laboratoire de Recherche Historique Rhône-Alpes, France)</li>
<li>George Bruseker (Foundation for Research and Technology - Hellas, Institute of Computer Science, CCI, Greece)</li>
</ul></p>

<h3>Organizing Committee</h3>
<p><ul><li>Edgard Marx (Leipzig University of Applied Sciences, Germany, edgard.marx@htwk-leipzig.de)</li>
<li>Jennifer Blanke (Herzog-August Library, Wolfenbüttel, Germany, blanke@hab.de)</li>
<li>Vincent Alamercery (École normale supérieure de Lyon, France, vincent.alamercery@ens-lyon.fr)
</ul>
</p>

<h3>Program Committee</h3>

<p><ul>
<li>Carmen Brando (EHESS, CRH)</li>
<li>Olivier Bruneau (Université de Lorraine, LHSP-AP)</li>
<li>Nicolas Guilhot (Université Jean-Moulin Lyon 3, IFROSS)</li>
<li>Torsten Hiltmann (Westfälische Wilhelms-Universität Münster)</li>
<li>Loïc Jeanson (Université de Nantes, CFV - LS2N)</li>
<li>Bärbel Kröger (Akademie der Wissenschaften zu Göttingen, Gemania Sacra)</li>
<li>Andreas Kuczera (Akademie der Wissenschaften und der Literatur Mainz, Digital Akademie)</li>
<li>Sylvain Laubé (Université de Bretagne Occidentale, CFV)</li>
<li>Matteo Lorenzini (Österreichische Akademie der Wissenschaften, ACDH)</li>
<li>Christopher Pollin (Karl-Franzens-Universität Graz, ZIM-ACDH)</li>
<li>Daniele Santarelli (Università degli Studi della Campania "Luigi Vanvitelli" and Associazione CLORI)</li>
<li>Matthias Schlögl (Österreichische Akademie der Wissenschaften, ACDH)</li>
<li>Regina Varnienė-Janssen (Vilniaus universitetas, Research Centre for the Organization of Libraries and Information)</li>
<li>Georg Vogeler (Karl-Franzens-Universität Graz, ZIM-ACDH)</li>
<li>Andreas Wagner (Max-Planck-Institut für europäische Rechtsgeschichte)</li>
<li>Veruska Zamborlini (Universiteit van Amsterdam, ILLC)</li>

</ul>
</p>

<h3>Contact</h3>

<p><ul>
<li>Prof. Dr. Thomas Riechert<br/>
Information Systems and Data Management</br>
Research Group: "Agile Knowledge Engineering and Semantic Web"<br/></li>

<li>Hochschule für Technik, Wirtschaft und Kultur Leipzig (HTWK)<br/>
Leipzig University of Applied Sciences<br/>
Faculty of Computer Science, Mathematics and Natural Sciences<br/>
Gustav-Freytag-Str. 42A, Zi. 507, 04277 Leipzig, Germany<br/></li>
<li>E-mail: thomas.riechert@htwk-leipzig.de phone +49 (341) 3076 6413 fax +49 (341) 3076 85 6413</li>
</ul>
</p>

<h3>Downloads</h3>

<p><ul>
<li><a href="pages/RODBH_2019_CfP.pdf" target="_blank">Call for Papers</a></li>
<li><a href="pages/RODBH_2019_Organisation.pdf" target="_blank">Information</a></li>
<li>Poster <a href="pages/RODBH_2019_Poster.pdf" target="_blank">PDF</a>, <li><a href="pages/RODBH_2019_Poster.png" target="_blank">PNG</a></li></li>
</ul>
</p>



    <!-- End Partner Content -->
    <?php echo section_end(); ?> 

