<!DOCTYPE html>
<html lang="de">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Professorale Karrieremuster Reloaded</title>
  	<link rel="stylesheet" href="../simple-grid.css"/>
  	<link rel="stylesheet" href="../index.css"/>
 		<link rel="stylesheet" href="../fonts/SourcePro/font.css">
  </head>
 <body>
  <div class="header row">
	  <div class="navigation col-12">
	  	
	  	<div class="left">
		  	<a href='../../#de' alt="Zurück zur Projektseite" title="Zurück zur Projektseite">← Zurück zur Projektseite: Professorale Karrieremuster der Frühen Neuzeit</a>
		  </div>
	  	<div class="right">
	  		Language/Sprache: 
		  	deutsch | <a href='../en/' alt="english" title="english">english</a>
		  </div>
  	
	  	<hr/>

	  </div>

	  </div>

	  <div class="headline row">
		  <div class="col-12">
				<h1>Konferenz, Workshop und Hackathon</h1>
				<h2>Professorale Karrieremuster Reloaded – Daten, Methoden und Analysen der digitalen Frühneuzeitforschung zur Universitäts- und Gelehrtenge­schichte</h2>
			</div>
		<div>
	  <div class="row">
		  <div class="col-2 hidden-sm">
	  		DFG Forschungs-Projekt
	  	</div>
		  <div class="col-10">
		  	Professorale Karrieremuster der Frühen Neuzeit
	  	</div>
	  </div>
	  <div class="row">
		  <div class="col-2 hidden-sm">
	  		Organisation
	  	</div>
		  <div class="col-6">
		  	<a href="https://hab.de">Herzog August Bibliothek Wolfenbüttel</a> und <a href="https://informatik.htwk-leipzig.de">Hochschule für Technik, Wirtschaft und Kultur Leipzig (HTWK)</a>
	  	</div>
		  <div class="col-4 ">
		  	<img class="logo" src="../img/hab.png" alt="HAB" title="Herzog August Bibliothek Wolfenbüttel"/>
		  	<img class="logo" src="../img/htwk.png" alt="HTWK" title="Hochschule für Technik, Wirtschaft und Kultur Leipzig"/>
		  	
	  	</div>

	  </div>

	  <div class="row">
		  <div class="col-2 hidden-sm">
	  		Termine
	  	</div>
		  <div class="col-10">
				<p>Abschlusstagung: 		27.–28.10.2021 </p>
				<p>Pre-Workshop/Hackathon: 	20.–21.10.2021</p>
				<p>Abstrakt-Einreichungen bis zum 03.09.2021</p>
				
	  	</div>
	  </div>

		<h3>Thema</h3>

		<div class="text">
			<p>Das DFG-Projekt „Professorale Karrieremuster der Frühen Neuzeit: Entwicklung einer wissenschaftlichen Methode zur Forschung auf online verfügbaren und verteilten Forschungsdatenbanken der Universitätsge­schichte“, durchgeführt von der Herzog August Bibliothek Wolfenbüttel in Kooperation mit der Hochschule für Technik, Wirtschaft und Kultur in Leipzig, lädt zur Abschlusstagung mit einem vorgelagerten Hackathon.
			</p>
			<p>Leitfrage des Projekts ist die nach den Bedingungen für den beruflichen Erfolg von Professoren im frühneu­zeitlichen Universitätssystem. Dabei ist es das Anliegen zu erproben wie mögliche gelehrte Karrieremuster mit den Methoden der Digital Humanities sichtbar gemacht werden können. In der Forschung diskutierte Karrieremuster mit Zuschreibungen wie Familiendynastie und Nepotismus sollen mithilfe von Semantic-Web-Technologien quasi einen digitalen Reload erleben.
			</p>
			<p>Vor diesem Hintergrund wurden prosopographische, universitätsgeschichtliche bzw. gelehrtengeschichtliche Daten den FAIR-Data-Prinzipien gemäß nach Semantic-Web-Standards modelliert und eine Domänenontolo­gie entworfen, welche die Spezifik des Gelehrten Feldes der Frühen Neuzeit im deutschsprachigen Raum re­flektiert und das vorhanden Datenmaterial forschungsspezifisch arrangiert. Die aktuelle Version 0.2 beinhal­tet das Modell mit relevanten Konzepten und deren Relationen. Die Version 0.3 befindet sich im abschließen­den Stadium des Entwicklungsprozesses, in welchem Restriktionen, Kardinalitäten und Schnittmengen dis­kutiert werden. Nicht zuletzt sollen die Anregungen der Abschlusstagung in das Endergebnis einfließen und letztlich eine Domänenontologie hervorbringen, die der Forschungsgemeinschaft zusätzlich durch Anglei­chung an Top-Level-Ontologien wie CIDOC-CRM oder DOLCE+DnS Ultralite (DUL) universell und inter­operabel zur Verfügung gestellt werden kann.
			</p>
		</div>

		<h3>Wir suchen</h3>
	
		<div class="text">
			<p>Dahingehend sprechen wir Frühneuzeitforscher*innen und Wissenschaftler*innen angrenzender Forschungsfelder mit Be­zug zu den Digital Humanities sowie Informatiker*innen und Informationswissenschaftler*innen an, die vor dem Hinter­grund der Forschungsfrage sowie der gewählten digitalen Methode das vorliegende Vokabular diskutieren, den Datensatz explorieren und übergreifend methodisch-theoretische Fragestellungen der digitalen Ge­schichtswissenschaft erörtern möchten. Zudem suchen wir explizit Forschungsdaten im Bereich der Bil­dungs- und Gelehrtengeschichte, die den besagten Datensatz und das Vokabular erweitern. Diese Daten kön­nen aus dem Bereich frühneuzeitlicher prosopographisch orientierter Forschung zur Geschichte des Gelehr­tentums bzw. des Professorenberufs stammen und mögliche Themen wie Patronage und Netzwerkbildung, die Funktionsweise gelehrter Körperschaften, gelehrte Sammlungen oder die Strategien des akademischen Publizierens usw. umfassen. Die vorgeschlagenen Daten müssen strukturiert (z. B. Excel, CSV, XML, JSON, SQL) vorliegen und unter einer Open-Data-kompatiblen Lizenz zur Verfügung stehen. Wenn Sie unsicher sind, ob ihre Daten bzw. Datenbanken thematisch und/oder technisch passen, sprechen Sie uns gerne an. Kurz vor der Abschluss­tagung werden wir einen Hackathon veranstalten, bei dem eingereichte Daten in das RDF-Format transfe­riert werden. So geben wir Forschenden die Möglichkeit, ihre Daten Semantic-Web-fähig zu machen und ermög­lichen es gleichsam Informatiker*innen mit den oftmals heterogenen frühneuzeitlichen Daten zu arbeiten.
			</p>
		</div>
			
		<h3>Ablauf und Formalia</h3>

		<div class="text">
			<p>Tagung und Hackathon werden rein digital geplant. Vorgesehen sind an den Tagungstagen sparsam ange­setz­te 20-minütige Vorträge mit genügend Raum für Diskussionen. Wir hoffen auf zahlreiche Einreichungen und werden auch jene einschlägigen Beiträge berücksichtigen, deren Verfasser*innen an den Tagungstagen keinen Vortragsslot erhalten können. Diese bekommen die Möglichkeit ein digitales Poster zu präsentieren. Beiträ­ger der Tagung und des Hackathons bzw. dessen Ergebnisse erhalten Raum in der im Anschluss an die Ta­gung geplanten Open-Access-Publikation. Für die Publikation stehen finanzielle Mittel zur Verfügung. So soll am Ende ein Tagungsband entstehen, der dem hybriden Charakter der Tagung Rechnung trägt und ak­tuelle Fragen der Universitäts- und Gelehrtengeschichte sowie methodisch-theroetische Überlegungen der Digital Humanities reflektiert.
			</p>
			<p>Beitrags- und Datenvorschläge bitten wir in Form eines Abstracts (max. 500 Wörter) über EasyChair (a href="https://easychair.org/conferences/?conf=pcpreloaded2021" target="_blank">https://easychair.org/conferences/?conf=pcpreloaded2021</a>) bis zum 03.09.2021 einzureichen. Ausgewählte Beiträge erhalten bis zum 07.09.2021 Bescheid.<p>
			<p>Konferenzsprachen Deutsch und Englisch</p>
		</div>
		
		<h3>Kontakt</h3>
	
		<ul>
			<li>Dr. Hartmut Beyer, Herzog August Bibliothek Wolfenbüttel, beyer@hab.de</li>
			<li>Jennifer Blanke, M.A., Herzog August Bibliothek Wolfenbüttel, blanke@hab.de</li>
			<li>Prof. Dr. Thomas Riechert, HTWK Leipzig, thomas.riechert@htwk-leipzig.de</li>
		</ul>

		<h3>Programmkomitee (*Anfragen laufen)</h3>
		<ul>
			<li>Vincent Alamercery* (CRNS LARHRA, Lyon)</li>
			<li>Francesco Beretta* (CRNS LARHRA, Lyon)</li>
			<li>Karen Bruhn (CAU Kiel)</li>
			<li>Swantje Dogunke (ThULB Jena)</li>
			<li>Torsten Hiltmann (HU Berlin)</li>
			<li>Edgard Marx (HTWK Leipzig)</li>
			<li>Margrit Prussat* (Universitätsarchiv Bamberg)</li>
			<li>Timo Steyer (UB der TU Braunschweig)</li>
			<li>Jörg Wettlaufer* (Akademie der Wissenschaften zu Göttingen)</li>
		</ul>
  </body>
</html

