	<div class="row">

		<div class="col-12">

		<h3>Topic</h3>

		<div class="text">
			<p>The DFG research project  “Early Modern Professorial Career Patterns – Methodological Research on Online Databases of Academic History“, collaboratively run by the Herzog August Library Wolfenbüttel and the Hochschule für Technik, Wirtschaft und Kultur in Leipzig, warmly invites you to participate in its concluding conference, to be held on 27-28 October 2021, alongside a preceding Hackathon, which will take place from 20-21 October 2021.
			</p>
			<p>Dedicated to investigating which conditions were necessary for professors in the early modern university system to attain professional success, our project aims to test how certain scholarly career patterns can be made more visible through the use of methods borrowed from the Digital Humanities. By these means, we hope that career patterns that are well known from the abiding scholarly literature, including family dynasties and incidents of nepotism, will undergo a kind of ‘digital reload’ with the aid of semantic web technologies.
			</p>
			<p>Following this premise, we have modeled prosopographic data, as well as data drawn from university and scholarly histories, according to semantic web standards and FAIR data principles. We have also designed an ontology that reflects the specificities of academic life in the early modern period in German-speaking countries, and arranged the existing data accordingly. Both this model, and its relevant concepts and relations, constitute Version 0.2, which can be viewed here.  Version 0.3, which is in the final stage of the development process, will address restrictions, cardinalities and intersections. We also plan to include suggestions from the concluding conference in our final results, which we hope will produce a domain ontology that can be made available to the broader research community in a universal and interoperable way by linking it to top-level ontologies, such as CIDOC-CRM oder DOLCE+DnS Ultralite (DUL).
			</p>
		</div>

		<h3>We ask for</h3>
	
		<div class="text">
			<p>We are interested in hearing from scholars of the early modern period,  scholars working in related fields with a special interest in the Digital Humanities, and computer and information scientists, who would like to discuss the project as outlined above, alongside its accompanying vocabulary and dataset, against the backdrop of larger, methodological-theoretical questions related to the Digital Humanities. Additionally, we are seeking research data from the history of education and scholarship with which to expand the aforementioned vocabulary and dataset. This data may come from early modern prosopographically oriented research on the history of scholarship or the professorial profession, and may include topics such as patronage and network formation; the activities of learned bodies, like scientific or learned societies; teaching and research collections belonging to professors; or the strategies of academic publishing etc. The proposed data must be presented in a structured manner (e.g. Excel, CSV, XML, JSON, SQL) and should be available under an Open Data license. If you are unsure whether your data or databases are thematically and/or technically compatible with our project, please do not hesitate to contact us. Shortly before the concluding conference, we will organize a hackathon during which the proposed data will be converted into RDF format. By these means, we hope to provide researchers with the opportunity to make their data Semantic Web capable, while at the same time enabling computer and information scientists to work with the frequently heterogeneous early modern data.
			</p>
		</div>
			
		<h3>Procedure and Formalities</h3>

		<div class="text">
			<p>The conference and hackathon will both be held online. For the conference, we invite 20-minute presentations, and plan to leave plenty of time for discussion after each paper. We hope to encourage as many submissions as possible, and will therefore also consider contributions whose authors cannot present on the days that have been earmarked for the conference, who will instead be given the opportunity to present a digital poster. Contributors to the conference as well as to the hackathon will be invited to participate in the open access publication that is planned for after the conference. Additional funding is available for this publication. It is our hope that the resulting volume will reflect the hybrid character of the conference, and engage with current questions concerning university and scholarly history, as well as methodological-theoretical issues in the Digital Humanities.
			</p>
			<p>Proposals for both the conference and the hackathon should be submitted in the form of an abstract (max. 500 words) via EasyChair (<a href="https://easychair.org/conferences/?conf=pcpreloaded2021" target="_blank">https://easychair.org/conferences/?conf=pcpreloaded2021</a>) by September 3, 2021. Successful applicants will be notified by September 10, 2021.<p>
			<p>Conference languages German and English</p>
		</div>
		
		<h3>Contact</h3>
	
		<ul>
			<li>Dr. Hartmut Beyer, Herzog August Bibliothek Wolfenbüttel, beyer@hab.de</li>
			<li>Jennifer Blanke, M.A., Herzog August Bibliothek Wolfenbüttel, blanke@hab.de</li>
			<li>Prof. Dr. Thomas Riechert, HTWK Leipzig, thomas.riechert@htwk-leipzig.de</li>
		</ul>

		<h3>Program Commitee</h3>
		<ul>
			<li>Vincent Alamercery (CRNS LARHRA, Lyon)</li>
			<li>Francesco Beretta (CRNS LARHRA, Lyon)</li>
			<li>Karen Bruhn (CAU Kiel)</li>
			<li>Swantje Dogunke (ThULB Jena)</li>
			<li>Torsten Hiltmann (HU Berlin)</li>
			<li>Edgard Marx (HTWK Leipzig)</li>
			<li>Margrit Prussat (Universitätsarchiv Bamberg)</li>
			<li>Timo Steyer (UB der TU Braunschweig)</li>
			<li>Jörg Wettlaufer (Akademie der Wissenschaften zu Göttingen)</li>
		</ul>
		</div>
	</div>
